/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[runtime]", module="[runtime]", source="byterun/meta.c")
public final class Meta {
    private Meta() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Obj.t array")
    public static Value caml_get_global_data(Value unit) throws Fail.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("Meta.get_global_data");
        }
        return runner.getContext().getCodeState().getGlobalData();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="(string * Obj.t) list")
    public static Value caml_get_section_table(Value unit) throws Fail.Exception {
        if (OCamlJavaThread.getCodeRunner().isNative()) {
            Fail.invalidArgument("Meta.get_section_table");
        }
        Fail.raiseNotFound();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="Meta.closure")
    public static Value caml_reify_bytecode(Value prog, Value len) throws Fail.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("Meta.reify_bytecode");
            return Value.UNIT;
        }
        byte[] b = prog.getBytes();
        assert (len.asLong() % 4L == 0L || len.asLong() > (long)b.length) : "invalid bytecode";
        int ln = len.asCastedInt() / 4;
        int[] code = new int[ln];
        for (int i = 0; i < ln; ++i) {
            code[i] = b[4 * i + 3] << 24 & 0xFF000000 | b[4 * i + 2] << 16 & 0xFF0000 | b[4 * i + 1] << 8 & 0xFF00 | b[4 * i] & 0xFF;
        }
        int codeOfs = runner.getContext().getCodeState().appendCode(code);
        return Value.createClosure(1L, (long)codeOfs);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "string"}, returnType="unit")
    public static Value caml_register_code_fragment(Value prog, Value len, Value digest) throws Fail.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("Meta.register_code_fragment");
            return Value.UNIT;
        }
        int ln = len.asCastedInt() / 4;
        runner.getContext().getCodeState().addFragment(ln, digest.getBytes());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_realloc_global(Value size) throws Fail.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("Meta.realloc_global");
        }
        runner.getContext().getCodeState().resizeGlobalData(size.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Obj.t")
    public static Value caml_get_current_environment(Value unit) {
        return ((ByteCodeRunner)OCamlJavaThread.getCodeRunner()).getEnv();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "Obj.t", "Obj.t"}, returnType="Obj.t")
    public static Value caml_invoke_traced_function(Value codePtr, Value env, Value arg) throws Fail.Exception, Fatal.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("Meta.invoke_traced_function");
        }
        ValueStack stack = ((ByteCodeRunner)runner).getStack();
        int valuesToMove = 6;
        Value[] values = stack.popSlice(6);
        stack.push(arg);
        stack.push(Value.ZERO);
        stack.push(env);
        stack.push(codePtr);
        stack.pushSlice(values);
        return Value.UNIT;
    }
}

