/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Pattern;

public abstract class AbstractPrimitivesConverter {
    private final String base;
    private final boolean negative;
    private final Pattern pattern;

    protected AbstractPrimitivesConverter(String b, String patt) {
        assert (b != null) : "null b";
        this.base = b;
        if (patt != null) {
            this.negative = patt.startsWith("-");
            this.pattern = this.negative ? Pattern.compile(patt.substring(1)) : Pattern.compile(patt);
        } else {
            this.negative = false;
            this.pattern = null;
        }
    }

    protected abstract void beforeWalk();

    protected abstract void visitClass(String var1);

    protected abstract void afterWalk();

    protected final void walkFileTree() throws IOException {
        this.beforeWalk();
        Files.walkFileTree(Paths.get(this.base, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                boolean isMatching;
                String fileName = file.toString();
                boolean isClassFile = attrs.isRegularFile() && fileName.endsWith(".class") && fileName.indexOf(36) == -1;
                boolean bl = isMatching = AbstractPrimitivesConverter.this.pattern == null || AbstractPrimitivesConverter.this.negative ^ AbstractPrimitivesConverter.this.pattern.matcher(fileName).matches();
                if (isClassFile && isMatching) {
                    int start = AbstractPrimitivesConverter.this.base.length() + 1;
                    int end = fileName.length() - 6;
                    String className = fileName.substring(start, end).replace('/', '.');
                    AbstractPrimitivesConverter.this.visitClass(className);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        this.afterWalk();
    }
}

