/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.AbstractLongBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.LongBlockValue0;
import org.ocamljava.runtime.values.LongBlockValue1;
import org.ocamljava.runtime.values.LongBlockValue2;
import org.ocamljava.runtime.values.LongBlockValue3;
import org.ocamljava.runtime.values.LongBlockValue4;
import org.ocamljava.runtime.values.LongBlockValue5;
import org.ocamljava.runtime.values.LongBlockValue6;
import org.ocamljava.runtime.values.LongBlockValue7;
import org.ocamljava.runtime.values.LongBlockValue8;
import org.ocamljava.runtime.values.Value;

public final class LongBlockValue
extends AbstractLongBlockValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private long[] values;

    LongBlockValue(int tag, int sz) {
        super(tag, sz);
        this.values = new long[sz];
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    LongBlockValue(int tag, long[] vals) {
        super(tag, vals.length);
        int sz = vals.length;
        this.values = vals;
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public long getRawLong0() {
        return this.values[0];
    }

    @Override
    public long getRawLong1() {
        return this.values[1];
    }

    @Override
    public long getRawLong2() {
        return this.values[2];
    }

    @Override
    public long getRawLong3() {
        return this.values[3];
    }

    @Override
    public long getRawLong4() {
        return this.values[4];
    }

    @Override
    public long getRawLong5() {
        return this.values[5];
    }

    @Override
    public long getRawLong6() {
        return this.values[6];
    }

    @Override
    public long getRawLong7() {
        return this.values[7];
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = x;
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = x;
    }

    @Override
    public void setRawLong0(long x) {
        this.values[0] = x;
    }

    @Override
    public void setRawLong1(long x) {
        this.values[1] = x;
    }

    @Override
    public void setRawLong2(long x) {
        this.values[2] = x;
    }

    @Override
    public void setRawLong3(long x) {
        this.values[3] = x;
    }

    @Override
    public void setRawLong4(long x) {
        this.values[4] = x;
    }

    @Override
    public void setRawLong5(long x) {
        this.values[5] = x;
    }

    @Override
    public void setRawLong6(long x) {
        this.values[6] = x;
    }

    @Override
    public void setRawLong7(long x) {
        this.values[7] = x;
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)sz;
        this.values = Arrays.copyOf(this.values, s);
        this.sizeTagged = s << 1 | 1;
        this.sizeMinusOneTagged = s - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeLongs());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.getRawLong(i);
        }
    }

    @Override
    public LongBlockValue duplicate() {
        int len = this.values.length;
        LongBlockValue res = new LongBlockValue(this.getTag(), len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createFromRawLong(this.values[i]);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createFromRawLong(this.values[i]);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i];
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        int tag = this.getTag();
        switch (l) {
            case 0: {
                return new LongBlockValue0(tag);
            }
            case 1: {
                return new LongBlockValue1(tag, this.values[o + 0]);
            }
            case 2: {
                return new LongBlockValue2(tag, this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new LongBlockValue3(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new LongBlockValue4(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new LongBlockValue5(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new LongBlockValue6(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new LongBlockValue7(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new LongBlockValue8(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        long[] v = new long[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new LongBlockValue(tag, v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof LongBlockValue) {
            LongBlockValue that = (LongBlockValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += (int)this.values[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongBlockValue) {
            LongBlockValue that = (LongBlockValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

