/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.Formatter;
import java.util.Locale;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.stdlib.Compare;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/floats.c")
public final class Floats {
    private static final Value FP_NORMAL = Value.ZERO;
    private static final Value FP_SUBNORMAL = Value.ONE;
    private static final Value FP_ZERO = Value.TWO;
    private static final Value FP_INFINITE = Value.THREE;
    private static final Value FP_NAN = Value.FOUR;

    private Floats() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "float"}, returnType="string")
    public static Value caml_format_float(Value f, Value v) {
        double d = v.asDouble();
        if (Double.isNaN(d)) {
            return Value.createString("nan");
        }
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return Value.createString("-inf");
            }
            return Value.createString("inf");
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.US);
        String format = f.asString();
        fmt.format(format, d);
        boolean exp = sb.indexOf("e") >= 0 || sb.indexOf("E") >= 0;
        switch (format.charAt(format.length() - 1)) {
            case 'F': {
                if (exp) break;
                while (sb.charAt(sb.length() - 1) == '0') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                break;
            }
            case 'G': 
            case 'g': {
                if (!exp) {
                    while (sb.charAt(sb.length() - 1) == '0') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
                if (sb.charAt(sb.length() - 1) != '.') break;
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
        }
        return Value.createString(fmt.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="float")
    public static Value caml_float_of_string(Value v) throws Fail.Exception {
        String s = v.asString();
        StringBuilder sb = new StringBuilder(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '_') continue;
            sb.append(ch);
        }
        if (sb.length() == 0) {
            Fail.failWith("float_of_string");
            return Value.UNIT;
        }
        try {
            return Value.createDouble(Double.parseDouble(sb.toString()));
        }
        catch (NumberFormatException nfe) {
            Fail.failWith("float_of_string");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="int")
    public static Value caml_int_of_float(Value f) {
        return Value.createLong((long)f.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="float")
    public static Value caml_float_of_int(Value n) {
        return Value.createDouble(n.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_neg_float(Value f) {
        return Value.createDouble(-f.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_abs_float(Value f) {
        return Value.createDouble(Math.abs(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_add_float(Value f, Value g) {
        return Value.createDouble(f.asDouble() + g.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_sub_float(Value f, Value g) {
        return Value.createDouble(f.asDouble() - g.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_mul_float(Value f, Value g) {
        return Value.createDouble(f.asDouble() * g.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_div_float(Value f, Value g) {
        return Value.createDouble(f.asDouble() / g.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_exp_float(Value f) {
        return Value.createDouble(Math.exp(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_floor_float(Value f) {
        return Value.createDouble(Math.floor(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_fmod_float(Value f, Value g) {
        return Value.createDouble(f.asDouble() % g.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float * float")
    public static Value caml_frexp_float(Value f) {
        long n;
        double sign;
        block4: {
            double dbl;
            block3: {
                dbl = f.asDouble();
                if (Double.isNaN(dbl) || Double.isInfinite(dbl) || dbl == 0.0) {
                    return Value.createBlock(0, Value.createDouble(dbl), Value.ZERO);
                }
                sign = Math.signum(dbl);
                dbl = Math.abs(dbl);
                n = 0L;
                if (!(dbl >= 1.0)) break block3;
                while (dbl >= 1.0) {
                    dbl /= 2.0;
                    ++n;
                }
                break block4;
            }
            if (!(dbl < 0.5)) break block4;
            while (dbl < 0.5) {
                dbl *= 2.0;
                --n;
            }
        }
        return Value.createBlock(0, Value.createDouble(dbl *= sign), Value.createLong(n));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "int"}, returnType="float")
    public static Value caml_ldexp_float(Value f, Value n) {
        return Value.createDouble(f.asDouble() * Math.pow(2.0, n.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log_float(Value f) {
        return Value.createDouble(Math.log(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log10_float(Value f) {
        return Value.createDouble(Math.log10(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float * float")
    public static Value caml_modf_float(Value f) {
        double d = f.asDouble();
        double dbl = Math.abs(d);
        boolean neg = d < 0.0;
        double v = Math.floor(dbl);
        double n = dbl - v;
        return Value.createBlock(0, Value.createDouble(neg ? -n : n), Value.createDouble(neg ? -v : v));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sqrt_float(Value f) {
        return Value.createDouble(Math.sqrt(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_power_float(Value f, Value g) {
        return Value.createDouble(Math.pow(f.asDouble(), g.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sin_float(Value f) {
        return Value.createDouble(Math.sin(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_sinh_float(Value f) {
        return Value.createDouble(Math.sinh(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_cos_float(Value f) {
        return Value.createDouble(Math.cos(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_cosh_float(Value f) {
        return Value.createDouble(Math.cosh(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_tan_float(Value f) {
        return Value.createDouble(Math.tan(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_tanh_float(Value f) {
        return Value.createDouble(Math.tanh(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_asin_float(Value f) {
        return Value.createDouble(Math.asin(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_acos_float(Value f) {
        return Value.createDouble(Math.acos(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_atan_float(Value f) {
        return Value.createDouble(Math.atan(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_atan2_float(Value f, Value g) {
        return Value.createDouble(Math.atan2(f.asDouble(), g.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_ceil_float(Value f) {
        return Value.createDouble(Math.ceil(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_hypot_float(Value f, Value g) {
        return Value.createDouble(Math.hypot(f.asDouble(), g.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_expm1_float(Value f) {
        return Value.createDouble(Math.expm1(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="float")
    public static Value caml_log1p_float(Value f) {
        return Value.createDouble(Math.log1p(f.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="float")
    public static Value caml_copysign_float(Value f, Value g) {
        return Value.createDouble(Math.copySign(f.asDouble(), g.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_eq_float(Value f, Value g) {
        return f.asDouble() == g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_neq_float(Value f, Value g) {
        return f.asDouble() != g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_le_float(Value f, Value g) {
        return f.asDouble() <= g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_lt_float(Value f, Value g) {
        return f.asDouble() < g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_ge_float(Value f, Value g) {
        return f.asDouble() >= g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="bool")
    public static Value caml_gt_float(Value f, Value g) {
        return f.asDouble() > g.asDouble() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float", "float"}, returnType="int")
    public static Value caml_float_compare(Value f, Value g) {
        double a = f.asDouble();
        double b = g.asDouble();
        if (Double.isNaN(a)) {
            if (Double.isNaN(b)) {
                return Compare.EQUAL_VALUE;
            }
            return Compare.LESS_VALUE;
        }
        if (Double.isNaN(b)) {
            return Compare.GREATER_VALUE;
        }
        if (a < b) {
            return Compare.LESS_VALUE;
        }
        if (a > b) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Pervasives.fpclass")
    public static Value caml_classify_float(Value v) {
        long bits = Double.doubleToRawLongBits(v.asDouble());
        int h = (int)(bits >> 32 & 0xFFFFFFFFL);
        int l = (int)(bits & 0xFFFFFFFFL);
        if (((h &= 0x7FF00000) | (l |= h & 0xFFFFF)) == 0) {
            return FP_ZERO;
        }
        if (h == 0) {
            return FP_SUBNORMAL;
        }
        if (h == 0x7FF00000) {
            if (l == 0) {
                return FP_INFINITE;
            }
            return FP_NAN;
        }
        return FP_NORMAL;
    }
}

