/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Int32Value
extends AbstractCustomValue {
    private static final long SIZE = Value.wosize(4L);
    private int int32;

    Int32Value(int v) {
        super(PredefinedCustomOperations.INT_32_OPS, SIZE);
        this.int32 = v;
    }

    @Override
    public int asInt32() {
        return this.int32;
    }

    @Override
    public void setInt32(int v) {
        this.int32 = v;
    }

    @Override
    public void copy(BlockValue src) {
        this.int32 = src.asInt32();
    }

    @Override
    public Int32Value duplicate() {
        return new Int32Value(this.int32);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        return this.int32;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Int32Value) {
            Int32Value that = (Int32Value)obj;
            return this.int32 == that.int32;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Int32Value(");
        sb.append(this.int32);
        sb.append(")");
        return sb.toString();
    }
}

