/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.gui;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.ocamljava.runtime.util.EncodingUtils;

final class CopyThread
extends Thread {
    private static final int BUFFER_SIZE = 65536;
    private final InputStream source;
    private final JTextArea destination;
    private final JComponent toRepaint;

    CopyThread(InputStream src, JTextArea dst, JComponent tr) {
        assert (src != null) : "null src";
        assert (dst != null) : "null dst";
        assert (tr != null) : "null tr";
        this.source = src;
        this.destination = dst;
        this.toRepaint = tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] buffer = new byte[65536];
            int nb = this.source.read(buffer);
            while (nb != -1) {
                JTextArea jTextArea = this.destination;
                synchronized (jTextArea) {
                    this.destination.append(EncodingUtils.convertBytesToString(buffer, 0, nb));
                    try {
                        int len = this.destination.getDocument().getLength();
                        int line = this.destination.getLineOfOffset(len);
                        int pos = this.destination.getLineStartOffset(line);
                        this.destination.setCaretPosition(pos);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                }
                this.toRepaint.repaint();
                nb = this.source.read(buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

