/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/connect.c")
public final class Connect {
    private Connect() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unix.sockaddr"}, returnType="unit")
    public static Value unix_connect(Value socket, Value addr) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("connect", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            ctxt.enterBlockingSection();
            ch.connect(new InetSocketAddress(InetAddress.getByAddress(addr.get0().getBytes()), addr.get1().asCastedInt()));
            ctxt.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            ctxt.leaveBlockingSection();
            Unix.fail("connect", ioe);
        }
        return Value.UNIT;
    }
}

