/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

final class Unix {
    static final String INVALID_DESCRIPTOR_MSG = "invalid descriptor";
    static final String UNSUPPORTED_SOCKOPT_MSG = "unsupported socket option";
    static final String DIRLISTING_CLOSED_MSG = "directory listing is closed";
    static final double MILLISECS_PER_SEC = 1000.0;

    private Unix() {
    }

    static void fail(String prim, Exception e) throws Fail.Exception {
        assert (prim != null) : "null prim";
        assert (e != null) : "null e";
        String msg = e.getMessage();
        Unix.fail(prim, msg != null ? msg : "");
    }

    static void fail(String prim, String msg) throws Fail.Exception {
        assert (prim != null) : "null prim";
        assert (msg != null) : "null msg";
        Value exn = OCamlJavaThread.getCodeRunner().getContext().getCodeState().getCallback("Unix.Unix_error");
        if (exn == null) {
            Fail.invalidArgument("Exception Unix.Unix_error not initialized, please link unix.cma");
        } else {
            Value res = Value.createBlock(0, exn, Value.ZERO, Value.createString(prim), Value.createString(msg));
            Fail.raise(res);
        }
    }

    static Value createInetAddr(InetAddress addr) throws Fail.Exception {
        if (addr != null) {
            return Value.createString(addr.getAddress());
        }
        Unix.fail("", "unable to get address");
        return Value.UNIT;
    }

    static Value createSockAddr(InetSocketAddress addr) throws Fail.Exception {
        if (addr != null) {
            return Value.createBlock(1, Unix.createInetAddr(addr.getAddress()), Value.createLong(addr.getPort()));
        }
        Unix.fail("", "unable to get socket address");
        return Value.UNIT;
    }

    static String emul(String prim, String cmd, String ... args) throws Fail.Exception, FalseExit {
        assert (prim != null) : "null prim";
        assert (cmd != null) : "null cmd";
        assert (args != null) : "null args";
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (!ctxt.getParameters().isUnixEmulated()) {
            Fail.invalidArgument("Unix." + prim + " not implemented");
            return null;
        }
        int len = args.length;
        String[] commandLine = new String[len + 1];
        commandLine[0] = Unix.lookupPath(cmd);
        System.arraycopy(args, 0, commandLine, 1, len);
        ProcessBuilder pb = new ProcessBuilder(commandLine);
        pb.directory(ctxt.getFilesState().getPwd());
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            InputStream out = p.getInputStream();
            int exitCode = p.waitFor();
            if (exitCode == 0) {
                StringBuilder sb = new StringBuilder();
                int x = out.read();
                while (x != -1) {
                    sb.append((char)x);
                    x = out.read();
                }
                return sb.toString();
            }
            return null;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
    }

    static String lookupPath(String path) {
        String sysPath = System.getenv("PATH");
        if (path.indexOf(File.separatorChar) == -1 && sysPath != null) {
            String[] pathElements;
            for (String pathElem : pathElements = sysPath.split(File.pathSeparator)) {
                File file = new File(pathElem, path);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return path;
    }

    static final class AlarmThread
    extends Thread {
        private static final String PREFIX = "OCaml-Java-AlarmThread-";
        private static final AtomicInteger NEXT_ID = new AtomicInteger();
        private final CodeRunner codeRunner;
        private final Context context;
        private long millis;
        private final long interval;
        private final SignalKind signal;
        private boolean activated;
        private long start;

        AlarmThread(CodeRunner runner, long val, long itv, SignalKind sgn) {
            super(runner.getContext().getThreadsState().getThreadGroup(), AlarmThread.getNextName());
            assert (runner != null) : "null runner";
            assert (val > 0L) : "val should be > 0";
            assert (itv >= 0L) : "itv should be >= 0";
            assert (sgn != null) : "null sgn";
            this.codeRunner = runner;
            this.context = runner.getContext();
            this.millis = val;
            this.interval = itv;
            this.signal = sgn;
            this.activated = true;
            this.start();
        }

        long getInterval() {
            return this.interval;
        }

        long getValue() {
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        long unactivate() {
            this.activated = false;
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        @Override
        public void run() {
            do {
                this.start = System.currentTimeMillis();
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (this.activated) {
                    Channel ch;
                    Signals.enqueueSignal(new Signal(this.signal));
                    try {
                        Signals.processSignal(this.codeRunner);
                    }
                    catch (FalseExit fe) {
                        this.context.getSignalsState().setAsyncException(fe);
                    }
                    catch (Fail.Exception fe) {
                        ch = this.context.getFilesState().getChannel(2);
                        Value globalData = this.context.getCodeState().getGlobalData();
                        String msg = Misc.convertException(fe.asValue(globalData), globalData);
                        Channel.tryWrite(ch, "Error in signal handler: exception " + msg);
                    }
                    catch (Fatal.Exception fe) {
                        ch = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(ch, "Error in signal handler: exception " + fe.getMessage());
                    }
                    catch (OCamlJavaException ie) {
                        ch = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(ch, "Error in signal handler: exception " + ie.getMessage());
                    }
                }
                this.millis = this.interval;
            } while (this.millis > 0L);
        }

        private static String getNextName() {
            StringBuilder sb = new StringBuilder(PREFIX);
            sb.append(NEXT_ID.getAndIncrement());
            return sb.toString();
        }
    }

    static final class DirList {
        private int nextIndex;
        private final String[] elems;
        private boolean open;

        DirList(File f) throws Fail.Exception {
            assert (f != null) : "null f";
            this.nextIndex = 0;
            String[] tmp = f.list();
            if (tmp != null) {
                int len = tmp.length;
                this.elems = new String[len + 2];
                this.elems[0] = ".";
                this.elems[1] = "..";
                System.arraycopy(tmp, 0, this.elems, 2, len);
                this.open = true;
            } else {
                Unix.fail("opendir", "unable to get directory content");
                this.elems = null;
                this.open = false;
            }
        }

        String next() throws Fail.Exception {
            if (this.open) {
                if (this.nextIndex < this.elems.length) {
                    return this.elems[this.nextIndex++];
                }
                Fail.raiseEndOfFile();
                return null;
            }
            Unix.fail("readdir", Unix.DIRLISTING_CLOSED_MSG);
            return null;
        }

        void rewind() throws Fail.Exception {
            if (this.open) {
                this.nextIndex = 0;
            } else {
                Unix.fail("rewinddir", Unix.DIRLISTING_CLOSED_MSG);
            }
        }

        void close() {
            this.open = false;
        }
    }
}

