/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/gethost.c")
public final class Gethost {
    private Gethost() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Array of aliases is always empty."}, parameterTypes={"Unix.inet_addr"}, returnType="Unix.host_entry")
    public static Value unix_gethostbyaddr(Value addr) throws Fail.Exception {
        try {
            return Gethost.createHost(new InetAddress[]{InetAddress.getByAddress(addr.getBytes())});
        }
        catch (UnknownHostException uhe) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Array of aliases is always empty."}, parameterTypes={"string"}, returnType="Unix.host_entry")
    public static Value unix_gethostbyname(Value name) throws Fail.Exception {
        try {
            return Gethost.createHost(InetAddress.getAllByName(name.asString()));
        }
        catch (UnknownHostException uhe) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    private static Value createHost(InetAddress[] addr) {
        int sz = addr.length;
        Value addresses = Value.createBlock(0, sz);
        for (int i = 0; i < sz; ++i) {
            addresses.set(i, Value.createString(addr[i].getAddress()));
        }
        return Value.createBlock(0, Value.createString(addr[0].getHostName()), OCamlJavaThread.getCodeRunner().getContext().getCodeState().getAtom(0), addr[0].getAddress().length == 4 ? Value.ONE : Value.TWO, addresses);
    }
}

