/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.support.scripting.OCamlBindings;
import org.ocamljava.runtime.support.scripting.OCamlCompiledScript;
import org.ocamljava.runtime.support.scripting.OCamlContext;
import org.ocamljava.runtime.support.scripting.OCamlScriptEngineFactory;
import org.ocamljava.runtime.util.CustomClassLoader;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.util.RedirectedInputStream;
import org.ocamljava.runtime.util.RedirectedOutputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class OCamlScriptEngine
implements ScriptEngine,
Compilable,
Invocable {
    private static final AtomicInteger ID = new AtomicInteger();
    private static Method COMPILER_MAIN;
    private ScriptContext context = new OCamlContext();
    private final Interpreter interpreter;
    private final List<String> libraryPaths = new LinkedList<String>();
    private final List<String> libraries = new LinkedList<String>();
    private final RedirectedInputStream in = new RedirectedInputStream(System.in);
    private final RedirectedOutputStream out = new RedirectedOutputStream(System.out);
    private final RedirectedOutputStream err = new RedirectedOutputStream(System.err);
    private PrintStream printOut = new PrintStream(this.out);
    private PrintStream printErr = new PrintStream(this.err);

    public OCamlScriptEngine() throws RuntimeException {
        try {
            int SIZE = 1024;
            byte[] buffer = new byte[1024];
            File tmp = File.createTempFile("ocamlscript", ".toplevel");
            InputStream is = OCamlScriptEngine.class.getResourceAsStream("/script");
            FileOutputStream os = new FileOutputStream(tmp);
            int read = is.read(buffer);
            while (read != -1) {
                ((OutputStream)os).write(buffer, 0, read);
                read = is.read(buffer);
            }
            is.close();
            ((OutputStream)os).close();
            RandomAccessInputStream bytecode = new RandomAccessInputStream(tmp);
            ByteCodeParameters params = Parameters.defaultByteCodeParameters();
            params = Parameters.setFile(params, tmp.getAbsolutePath());
            params = Parameters.setUnparsedElements(params, new String[]{"-w", "a"});
            params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.STOP_JVM, false);
            params = Parameters.setInputStreamParameter(params, CommonParameters.InputStreamParameterID.IN, (InputStream)this.in);
            params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.OUT, this.printOut);
            params = Parameters.setPrintStreamParameter(params, CommonParameters.PrintStreamParameterID.ERR, this.printErr);
            params = Parameters.setBooleanParameter(params, CommonParameters.BooleanParameterID.EMBEDDED, true);
            this.interpreter = new Interpreter(params, new File("."), bytecode, new CustomOperations[0]);
            bytecode.close();
            this.interpreter.execute();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create script engine", ioe);
        }
        catch (Fatal.Exception fe) {
            throw new RuntimeException("Unable to create script engine", fe);
        }
        catch (OCamlJavaException e) {
            throw new RuntimeException("Unable to create script engine", e);
        }
    }

    public void addLibraryPath(String path) throws NullPointerException, ScriptException {
        if (path != null) {
            if (!this.libraryPaths.contains(path)) {
                this.libraryPaths.add(path);
            }
            try {
                this.interpreter.execute("ocamljava javax.script.directory", Value.createString(path));
            }
            catch (OCamlJavaException e) {
                throw new ScriptException(e);
            }
        } else {
            throw new NullPointerException();
        }
    }

    public void loadLibrary(String lib) throws NullPointerException, ScriptException {
        if (lib != null) {
            if (!this.libraries.contains(lib)) {
                this.libraries.add(lib);
            }
            try {
                this.interpreter.execute("ocamljava javax.script.load", Value.createString(lib + ".cma"));
            }
            catch (OCamlJavaException e) {
                throw new ScriptException(e);
            }
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public Bindings createBindings() {
        return new OCamlBindings();
    }

    @Override
    public Object eval(Reader reader) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(this.context));
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(n)));
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws NullPointerException, ScriptException {
        try {
            return this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(context));
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    @Override
    public Object eval(String script) throws NullPointerException, ScriptException {
        return this.evaluate(script, OCamlContext.instance(this.context));
    }

    @Override
    public Object eval(String script, Bindings n) throws NullPointerException, ScriptException {
        return this.evaluate(script, new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(n)));
    }

    @Override
    public Object eval(String script, ScriptContext context) throws NullPointerException, ScriptException {
        return this.evaluate(script, OCamlContext.instance(context));
    }

    @Override
    public Object get(String key) throws NullPointerException, IllegalArgumentException {
        return this.getBindings(100).get(key);
    }

    @Override
    public Bindings getBindings(int scope) throws IllegalArgumentException {
        return this.context.getBindings(scope);
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new OCamlScriptEngineFactory();
    }

    @Override
    public void put(String key, Object value) throws NullPointerException, IllegalArgumentException {
        this.getBindings(100).put(key, value);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) throws NullPointerException, IllegalArgumentException {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void setContext(ScriptContext context) throws NullPointerException {
        this.context = context;
    }

    @Override
    public CompiledScript compile(String script) throws NullPointerException, ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        if (COMPILER_MAIN == null) {
            throw new ScriptException("OCaml-Java compiler is not available");
        }
        try {
            int id = ID.getAndIncrement();
            String pack = "org.ocamljava.runtime.support.scripting.generated" + id;
            File ml = File.createTempFile("ocamlscript", ".ml");
            File jar = File.createTempFile("ocamlscript", ".jar");
            FileWriter writer = new FileWriter(ml);
            writer.write(script);
            ((Writer)writer).close();
            LinkedList<String> paramList = new LinkedList<String>();
            for (String s : this.libraryPaths) {
                paramList.add("-I");
                paramList.add(s);
            }
            for (String s : this.libraries) {
                paramList.add(s + ".cmja");
            }
            paramList.add("-w");
            paramList.add("a");
            paramList.add("-scripting");
            paramList.add("-runtime-parameter");
            paramList.add("exitStoppingJVM=off");
            paramList.add("-java-package");
            paramList.add(pack);
            paramList.add("-o");
            paramList.add(jar.getAbsolutePath());
            paramList.add(ml.getAbsolutePath());
            String[] params = paramList.toArray(new String[paramList.size()]);
            COMPILER_MAIN.invoke(null, new Object[]{params});
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file://" + jar.getAbsolutePath())}, (ClassLoader)CustomClassLoader.INSTANCE);
            Class<?> cl = Class.forName(pack + ".ocamljavaMain", true, loader);
            Method main = cl.getMethod("mainScripting", String[].class, Map.class, InputStream.class, PrintStream.class, PrintStream.class);
            return new OCamlCompiledScript(this, main, this.context);
        }
        catch (IllegalAccessException iae) {
            throw new ScriptException("Unable to compile script");
        }
        catch (InvocationTargetException ite) {
            throw new ScriptException("Unable to compile script");
        }
        catch (NoSuchMethodException nsme) {
            throw new ScriptException("Unable to compile script");
        }
        catch (ClassNotFoundException cnfe) {
            throw new ScriptException("Unable to compile script");
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    @Override
    public CompiledScript compile(Reader script) throws NullPointerException, ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        try {
            return this.compile(OCamlScriptEngine.readerToString(script));
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException, NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException, NullPointerException {
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
        OCamlContext ctxt = OCamlContext.instance(this.context);
        this.in.redirect(ctxt.getStdIn());
        this.out.redirect(ctxt.getStdOut());
        this.err.redirect(ctxt.getStdErr());
        try {
            int len = args.length;
            Value[] arguments = new Value[len];
            for (int i = 0; i < len; ++i) {
                arguments[i] = OCamlBindings.convert(args[i]);
            }
            return this.interpreter.execute(name, arguments);
        }
        catch (OCamlJavaException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    private Object evaluate(String script, OCamlContext context) throws ScriptException {
        assert (script != null) : "null script";
        assert (context != null) : "null context";
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException ioe) {
            throw new ScriptException(ioe);
        }
        this.in.redirect(context.getStdIn());
        this.out.redirect(context.getStdOut());
        this.err.redirect(context.getStdErr());
        try {
            String code = script + "\n";
            return this.interpreter.executeWithBindings("ocamljava javax.script.eval", context.getBindings(), Value.createString(code));
        }
        catch (OCamlJavaException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Fail.Exception) {
                Value msg;
                Fail.Exception fe = (Fail.Exception)cause;
                Value val = fe.asValue(this.interpreter.getContext().getCodeState().getGlobalData());
                Value value = msg = val.isBlock() && val.asBlock().sizeValues() >= 2L ? val.asBlock().get1() : null;
                if (msg != null && msg.isBlock() && msg.getTag() == 252) {
                    throw new ScriptException(msg.asString());
                }
                throw new ScriptException(e);
            }
            if (cause instanceof Fatal.Exception) {
                throw new ScriptException(cause.getMessage());
            }
            throw new ScriptException(e);
        }
    }

    private static String readerToString(Reader reader) throws IOException {
        assert (reader != null) : "null reader";
        int SIZE = 1024;
        StringWriter res = new StringWriter(1024);
        char[] buffer = new char[1024];
        int read = reader.read(buffer);
        while (read != -1) {
            res.write(buffer, 0, read);
            read = reader.read(buffer);
        }
        return res.toString();
    }

    static {
        try {
            Class<?> cls = Class.forName("ocaml.compilers.ocamljavaMain");
            COMPILER_MAIN = cls.getMethod("mainWithReturn", String[].class);
        }
        catch (Throwable t) {
            COMPILER_MAIN = null;
        }
    }
}

