/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Set;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/signals.c")
public final class Signals {
    private Signals() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.sigprocmask_command", "int list"}, returnType="int list")
    public static Value unix_sigprocmask(Value vaction, Value vset) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Set<Integer> mask = ctxt.getSignalsState().blockSignals(vaction.asCastedInt(), org.ocamljava.runtime.kernel.Signals.decodeSignalSet(vset));
        return org.ocamljava.runtime.kernel.Signals.encodeSignalSet(mask);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int list")
    public static Value unix_sigpending(Value unit) {
        return org.ocamljava.runtime.kernel.Signals.encodeSignalSet(OCamlJavaThread.getCodeRunner().getContext().getSignalsState().getPendingSignals());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int list"}, returnType="unit")
    public static Value unix_sigsuspend(Value vset) throws FalseExit, Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        ctxt.enterBlockingSection();
        org.ocamljava.runtime.kernel.Signals.waitForSignal(ctxt, org.ocamljava.runtime.kernel.Signals.decodeSignalSet(vset));
        ctxt.leaveBlockingSection();
        return Value.UNIT;
    }
}

