/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.util.ShellUtils;
import org.ocamljava.runtime.util.StreamCopyThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/execv.c")
public final class Execv {
    private Execv() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulated by program execution, then interpretation stop. Process name is thus not set."}, parameterTypes={"string", "string array"}, returnType="'a")
    public static Value unix_execv(Value path, Value args) throws Fail.Exception, Fatal.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        int sz = (int)args.sizeValues();
        String[] a = new String[sz];
        for (int i = 0; i < sz; ++i) {
            a[i] = args.get(i).asString();
        }
        a[0] = ctxt.getFilesState().getRealFile(path).getAbsolutePath();
        try {
            Channel in;
            Channel err;
            ProcessBuilder pb = new ProcessBuilder(ShellUtils.prepareArguments(a));
            pb.directory(ctxt.getFilesState().getPwd());
            Process p = pb.start();
            Channel out = ctxt.getFilesState().getChannel(1);
            StreamCopyThread[] threads = new StreamCopyThread[2];
            int nbThreads = 0;
            if (out != null) {
                StreamCopyThread sct = new StreamCopyThread(out.newOutputStream(), p.getInputStream());
                threads[nbThreads++] = sct;
                sct.start();
            }
            if ((err = ctxt.getFilesState().getChannel(2)) != null) {
                StreamCopyThread sct = new StreamCopyThread(err.newOutputStream(), p.getErrorStream());
                threads[nbThreads++] = sct;
                sct.start();
            }
            if ((in = ctxt.getFilesState().getChannel(0)) != null) {
                StreamCopyThread sct = new StreamCopyThread(p.getOutputStream(), in.newInputStream());
                sct.start();
            }
            int exitCode = p.waitFor();
            try {
                p.getInputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                p.getOutputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                p.getErrorStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            for (int i = 0; i < nbThreads; ++i) {
                threads[i].join();
            }
            return Sys.caml_sys_exit(Value.createLong(exitCode));
        }
        catch (FalseExit sfe) {
            throw sfe;
        }
        catch (InterruptedException ie) {
            Unix.fail("execv", ie);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("execv", ioe);
        }
        return Value.UNIT;
    }
}

