/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/chmod.c")
public final class Chmod {
    private Chmod() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "Unix.file_perm"}, returnType="unit")
    public static Value unix_chmod(Value path, Value perm) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        File f = ctxt.getFilesState().getRealFile(path);
        try {
            PermissionsUtils.setPermissions(f, perm.asCastedInt());
        }
        catch (Exception e) {
            Unix.fail("chmod", "unable to change file permissions");
        }
        return Value.UNIT;
    }
}

