/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.values.Value;

public final class ThreadLocalFactory {
    private static final List<WeakReference<ThreadLocal<Value>>> LIST = new LinkedList<WeakReference<ThreadLocal<Value>>>();
    private static final ThreadLocal<Value> BACKTRACE = new ThreadLocal<Value>(){

        @Override
        protected Value initialValue() {
            CodeRunner runner = OCamlJavaThread.getCodeRunner();
            CommonParameters params = runner.getContext().getParameters();
            return params.isBacktraceRequested() ? Value.TRUE : Value.FALSE;
        }
    };

    private ThreadLocalFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocal<Value> constantsStorage(final Class<?> id) {
        assert (id != null) : "null id";
        ThreadLocal<Value> res = new ThreadLocal<Value>(){

            @Override
            protected Value initialValue() {
                return AbstractNativeRunner.getConstants(id);
            }
        };
        List<WeakReference<ThreadLocal<Value>>> list = LIST;
        synchronized (list) {
            LIST.add(new WeakReference<2>(res));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocal<Value> globalStorage(final String id) {
        assert (id != null) : "null id";
        ThreadLocal<Value> res = new ThreadLocal<Value>(){

            @Override
            protected Value initialValue() {
                return AbstractNativeRunner.getGlobal(id);
            }
        };
        List<WeakReference<ThreadLocal<Value>>> list = LIST;
        synchronized (list) {
            LIST.add(new WeakReference<3>(res));
        }
        return res;
    }

    public static ThreadLocal<Value> backTraceStorage() {
        return BACKTRACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove() {
        List<WeakReference<ThreadLocal<Value>>> list = LIST;
        synchronized (list) {
            Iterator<WeakReference<ThreadLocal<Value>>> it = LIST.iterator();
            while (it.hasNext()) {
                WeakReference<ThreadLocal<Value>> ref = it.next();
                ThreadLocal val = (ThreadLocal)ref.get();
                if (val != null) {
                    val.remove();
                    continue;
                }
                it.remove();
            }
        }
    }

    static {
        LIST.add(new WeakReference<ThreadLocal<Value>>(BACKTRACE));
    }
}

