/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="CyclicBarrier", source="")
public final class CyclicBarrier {
    private CyclicBarrier() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="CyclicBarrier.t")
    public static Value ocamljava_cyclicbarrier_make(Value parties) throws Fail.Exception {
        try {
            return Value.createInstance(new java.util.concurrent.CyclicBarrier(parties.asInt32()));
        }
        catch (Throwable t) {
            Fail.failWith("CyclicBarrier.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_await(Value obj) throws Fail.Exception {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        try {
            inst.await();
            return Value.UNIT;
        }
        catch (InterruptedException | BrokenBarrierException e) {
            Fail.failWith("CyclicBarrier.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_await_time(Value obj, Value timeout, Value unit) throws Fail.Exception {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        try {
            inst.await(timeout.asInt64(), TimeUnit.decode(unit));
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Fail.failWith("CyclicBarrier.await");
            return Value.UNIT;
        }
        catch (BrokenBarrierException bbe) {
            Fail.failWith("CyclicBarrier.await: broken barrier");
            return Value.UNIT;
        }
        catch (TimeoutException te) {
            Fail.failWith("CyclicBarrier.await: timeout");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="int32")
    public static Value ocamljava_cyclicbarrier_get_number_waiting(Value obj) {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        int res = inst.getNumberWaiting();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="int32")
    public static Value ocamljava_cyclicbarrier_get_parties(Value obj) {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        int res = inst.getParties();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="bool")
    public static Value ocamljava_cyclicbarrier_is_broken(Value obj) {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        boolean res = inst.isBroken();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_reset(Value obj) {
        java.util.concurrent.CyclicBarrier inst = (java.util.concurrent.CyclicBarrier)obj.asCustom();
        inst.reset();
        return Value.UNIT;
    }
}

