/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractNativeRunner
extends AbstractCodeRunner
implements Executable {
    protected Value result;
    protected Throwable exception;
    private final Map<Class<?>, Value> constants;
    private final Map<String, Value> globals;
    private int globalsInited;
    private Throwable backtraceInfo;

    public AbstractNativeRunner(NativeParameters np) {
        super(np.hasRuntimeLock() ? new ContextWithRuntimeLock(np, true, new File(".")) : new ContextWithoutRuntimeLock(np, true, new File(".")));
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.constants = new HashMap();
        this.globals = new HashMap<String, Value>();
        this.globalsInited = 0;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public AbstractNativeRunner(AbstractNativeRunner that) {
        super(that.context);
        this.constants = that.constants;
        this.globals = that.globals;
        this.globalsInited = that.globalsInited;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public final Value getResult() {
        return this.result;
    }

    public static void checkSignals() throws Fail.Exception, Fatal.Exception, FalseExit, OCamlJavaException {
        Signals.processSignal(OCamlJavaThread.getCodeRunner());
    }

    public static Value getAtom(int atm) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        return ctxt.getCodeState().getAtom(atm);
    }

    public static Value loadConstants(Class<?> id) throws OCamlJavaException {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        try {
            InputStream is = id.getResourceAsStream(id.getSimpleName() + ".consts");
            if (is == null) {
                throw new OCamlJavaException("unable to load constants for " + id);
            }
            DataInputStream dis = new DataInputStream(is);
            Value consts = MarshalIntern.inputVal(ctxt, dis, true);
            dis.close();
            is.close();
            return consts;
        }
        catch (IOException | Fail.Exception | Fatal.Exception e) {
            throw new OCamlJavaException("unable to load constants for " + id, e);
        }
    }

    public final void loadConstant(Class<?> id) throws OCamlJavaException {
        Value consts = AbstractNativeRunner.loadConstants(id);
        this.constants.put(id, consts);
    }

    public static Value getConstant(Class<?> id, long idx) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        return ((AbstractNativeRunner)runner).constants.get(id).get(idx);
    }

    public static Value getConstants(Class<?> id) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        return ((AbstractNativeRunner)runner).constants.get(id);
    }

    public static Value createGlobal(String id, long sz) {
        assert (id != null) : "null id";
        assert (sz >= 0L) : "sz should be >= 0";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Value bl = Value.createBlock(0, sz);
        ((AbstractNativeRunner)runner).globals.put(id, bl);
        return bl;
    }

    public final void registerPredefinedException(String name) {
        assert (name != null) : "null name";
        String bucketName = "caml_bucket_" + name;
        String symName = "caml_exn_" + name;
        Value symValue = Value.createBlock(0, Value.createString(name));
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        this.globals.put(symName, symValue);
        this.globals.put(bucketName, Value.createBlock(0, symValue));
    }

    public static Value getGlobal(String id) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        return ((AbstractNativeRunner)runner).globals.get(id);
    }

    final Value getGlobalFromInstance(String id) {
        assert (id != null) : "null id";
        return this.globals.get(id);
    }

    public static void setGlobal(String id, Value val) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        ((AbstractNativeRunner)runner).globals.put(id, val);
    }

    public final int getGlobalsInited() {
        return this.globalsInited;
    }

    public final void incrGlobalsInited() {
        ++this.globalsInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value callback(Value closure, Value ... params) throws Fail.Exception, Fatal.Exception, FalseExit {
        boolean addTemporarily;
        assert (closure != null) : "null closure";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Thread currentThread = Thread.currentThread();
        boolean isOCamlJavaThread = currentThread instanceof OCamlJavaThread;
        boolean isRegistered = OCamlJavaThread.isRegistered(currentThread);
        boolean bl = addTemporarily = !isOCamlJavaThread && !isRegistered;
        if (addTemporarily) {
            this.context.getThreadsState().addAdditionalThread(currentThread);
        }
        AbstractNativeRunner runner = this.copy();
        runner.threadStatus = null;
        runner.setup(closure, params);
        runner.exception = null;
        try {
            runner.run();
        }
        finally {
            if (!addTemporarily) {
                this.context.getThreadsState().removeAdditionalThread(currentThread);
            }
        }
        if (runner.exception != null) {
            if (runner.exception instanceof Fail.Exception) {
                throw (Fail.Exception)runner.exception;
            }
            if (runner.exception instanceof Fatal.Exception) {
                throw (Fatal.Exception)runner.exception;
            }
            if (runner.exception instanceof FalseExit) {
                boolean backtrace = this.context.getCodeState().isBacktraceActive();
                this.context.getCodeState().setBacktraceActive(false);
                Value atExit = this.context.getCodeState().getCallback("Pervasives.do_at_exit");
                if (atExit != null) {
                    try {
                        this.callback(atExit, Value.UNIT);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.context.getCodeState().setBacktraceActive(backtrace);
                throw (FalseExit)runner.exception;
            }
            Fatal.raise("error in callback: " + runner.exception);
        }
        return runner.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.result = null;
        this.exception = null;
        try {
            this.context.leaveBlockingSection();
        }
        catch (Fail.Exception fe) {
            return;
        }
        catch (FalseExit fe) {
            return;
        }
        try {
            if (this.closure == null) {
                try {
                    this.moduleMain();
                }
                catch (Throwable t) {
                    this.setBacktraceInfo(t);
                    this.exception = t;
                }
            } else {
                try {
                    this.result = NativeApply.apply(this.closure, this.args);
                }
                catch (Throwable t) {
                    this.setBacktraceInfo(t);
                    this.exception = t;
                }
            }
        }
        finally {
            if (this.threadStatus != null) {
                ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
            }
            this.context.enterBlockingSection();
        }
    }

    public final void execute() {
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.context.getThreadsState().setMainCodeRunner(this);
        this.setup(null, new Value[0]);
        OCamlJavaThread thread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), this);
        this.context.getThreadsState().setMainThread(thread);
        thread.start();
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        if (this.exception != null && !(this.exception instanceof FalseExit)) {
            PrintStream err;
            Channel ch = this.context.getFilesState().getChannel(2);
            if (ch != null && ch.isOutputChannel()) {
                Object altErr = null;
                err = new PrintStream(ch.newOutputStream(), true);
            } else {
                ByteArrayOutputStream altErr = new ByteArrayOutputStream();
                err = new PrintStream(altErr, true);
            }
            boolean backtrace = this.context.getCodeState().isBacktraceActive();
            this.context.getCodeState().setBacktraceActive(false);
            Value atExit = this.context.getCodeState().getCallback("Pervasives.do_at_exit");
            if (atExit != null) {
                try {
                    this.callback(atExit, Value.UNIT);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.context.getCodeState().setBacktraceActive(backtrace);
            if (this.exception instanceof Fail.Exception) {
                String msg = Misc.convertException(((Fail.Exception)this.exception).asValue(), null);
                err.println("Fatal error: exception " + msg);
                if (this.context.getCodeState().isBacktraceActive()) {
                    this.printExceptionBacktrace(err);
                }
                err.close();
                return;
            }
            if (this.exception instanceof Fatal.Exception) {
                err.println(((Fatal.Exception)this.exception).getMessage());
                err.close();
                return;
            }
            err.println(this.exception.toString());
            err.close();
            return;
        }
        boolean backtrace = this.context.getCodeState().isBacktraceActive();
        this.context.getCodeState().setBacktraceActive(false);
        Value atExit = this.context.getCodeState().getCallback("Pervasives.do_at_exit");
        if (atExit != null) {
            try {
                this.callback(atExit, Value.UNIT);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.context.getCodeState().setBacktraceActive(backtrace);
    }

    @Override
    public final void executeSilently() {
        this.execute();
    }

    public final void executeWithBindings(Map<String, Value> bindings) {
        this.bindings = bindings;
        this.execute();
    }

    private StackTraceElement[] filterBackTrace(StackTraceElement[] elems) {
        assert (elems != null) : "null elems";
        boolean simplified = ((NativeParameters)this.context.getParameters()).isSimplifiedBacktrace();
        ArrayList<StackTraceElement> l = new ArrayList<StackTraceElement>(Arrays.asList(elems));
        Iterator it = l.iterator();
        while (it.hasNext()) {
            boolean filtered;
            StackTraceElement e = (StackTraceElement)it.next();
            String className = e.getClassName();
            boolean bl = filtered = className.startsWith("java.lang.") || className.startsWith("java.lang.reflect.") || className.startsWith("java.lang.invoke.") || className.startsWith("org.ocamljava.runtime.kernel.") || className.startsWith("org.ocamljava.runtime.values.");
            if ((!simplified || !filtered) && e.getFileName() != null && e.getLineNumber() >= 0) continue;
            it.remove();
        }
        return l.toArray(new StackTraceElement[l.size()]);
    }

    @Override
    public final void printExceptionBacktrace(PrintStream out) {
        assert (out != null) : "null out";
        for (StackTraceElement elem : this.filterBackTrace(this.exception.getStackTrace())) {
            out.println("\tat " + elem);
        }
    }

    public final void setBacktraceInfo(Throwable t) {
        if (this.context.getCodeState().isBacktraceActive()) {
            this.backtraceInfo = t;
        }
    }

    @Override
    public final void clearBacktraceInfo() {
        this.backtraceInfo = null;
    }

    public final void clearException() {
        this.exception = null;
    }

    @Override
    public final Value getExceptionBacktrace() {
        if (this.backtraceInfo != null) {
            StackTraceElement[] l = this.filterBackTrace(this.backtraceInfo.getStackTrace());
            int len = l.length;
            Value arr = Value.createBlock(0, len);
            for (int i = 0; i < len; ++i) {
                StackTraceElement e = l[i];
                Value p = Value.createBlock(0, i == 0 ? Value.TRUE : Value.FALSE, Value.createString(e.getFileName()), Value.createLong(e.getLineNumber()), Value.ZERO, Value.ZERO);
                arr.set(i, p);
            }
            return Value.createBlock(0, arr);
        }
        return Value.createBlock(0, Value.createBlock(0));
    }

    @Override
    public final CodeRunner createNewThread(Value status) {
        AbstractNativeRunner res = this.copy();
        if (status != null) {
            res.setThreadStatus(status);
        }
        return res;
    }

    protected abstract AbstractNativeRunner copy();

    protected abstract void moduleMain();
}

