/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarFile;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.util.JarClassLoader;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Dynlink", source="asmrun/natdynlink.c")
public final class NatDynlink {
    private NatDynlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_natdynlink_getmap(Value unit) throws Fatal.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        InputStream is = runner.getClass().getResourceAsStream("ocamljavaMain.gmap");
        if (is != null) {
            return Value.createString(NatDynlink.readBytes(is));
        }
        Fatal.raise("Fatal error: globals map is missing");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_natdynlink_globals_inited(Value unit) {
        return Value.createLong(((AbstractNativeRunner)OCamlJavaThread.getCodeRunner()).getGlobalsInited());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "bool"}, returnType="Dynlink.handle * string")
    public static Value caml_natdynlink_open(Value filename, Value global) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        File file = ctxt.getFilesState().getRealFile(filename);
        try {
            URL url = file.toURI().toURL();
            JarClassLoader loader = ctxt.getCodeState().getClassLoader();
            loader.addJarFile(url);
            JarFile jar = new JarFile(file);
            byte[] header = NatDynlink.readBytes(jar.getInputStream(jar.getEntry("/PluginHeader")));
            Properties props = new Properties();
            props.load(jar.getInputStream(jar.getEntry("/PluginMembers")));
            Value handle = Value.createAbstract(0L, new Handle(loader, jar, props));
            Value data = Value.createString(header);
            return Value.createBlock(0, handle, data);
        }
        catch (Throwable t) {
            return Value.createString("not an OCaml plugin");
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Dynlink.handle", "string"}, returnType="unit")
    public static Value caml_natdynlink_run(Value handle, Value symbol) throws Fail.Exception {
        String s = symbol.asString();
        Handle h = (Handle)handle.asCustom();
        if (!s.equals("_shared_startup")) {
            String additionalClasses = h.properties.getProperty(s + "*");
            if (additionalClasses != null) {
                for (String name : additionalClasses.split(",")) {
                    NatDynlink.executeEntry(h.classLoader, name.trim());
                }
            }
            String className = h.properties.getProperty(s).trim();
            return NatDynlink.executeEntry(h.classLoader, className);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="Opttoploop.res")
    public static Value caml_natdynlink_run_toplevel(Value filename, Value symbol) throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        File file = ctxt.getFilesState().getRealFile(filename);
        try {
            URL url = file.toURI().toURL();
            JarClassLoader loader = ctxt.getCodeState().getClassLoader();
            loader.addJarFile(url);
            JarFile jar = new JarFile(file);
            Properties props = new Properties();
            String fullName = symbol.asString();
            String shortName = fullName.substring(fullName.lastIndexOf(46) + 1);
            props.put(shortName, fullName);
            Value handle = Value.createAbstract(0L, new Handle(loader, jar, props));
            Value res = NatDynlink.caml_natdynlink_run(handle, Value.createString(shortName));
            return Value.createBlock(0, res);
        }
        catch (Throwable t) {
            return Value.createBlock(1, Value.createString("Unable to load phrase object (" + t.toString() + ")"));
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="Obj.t")
    public static Value caml_natdynlink_loadsym(Value symbol) {
        return AbstractNativeRunner.getGlobal(symbol.asString());
    }

    private static byte[] readBytes(InputStream is) {
        if (is != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int b = is.read();
                while (b != -1) {
                    baos.write(b);
                    b = is.read();
                }
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                return new byte[0];
            }
        }
        return new byte[0];
    }

    private static Value executeEntry(ClassLoader classLoader, String className) throws Fail.Exception {
        assert (classLoader != null) : "null classLoader";
        assert (className != null) : "null className";
        try {
            Class<?> cl = Class.forName(className, true, classLoader);
            ((AbstractNativeRunner)OCamlJavaThread.getCodeRunner()).loadConstant(cl);
            Method m = cl.getMethod("entry", new Class[0]);
            return (Value)m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Fail.Exception) {
                throw (Fail.Exception)t;
            }
            Fail.invalidArgument("not an OCaml plugin");
            return Value.UNIT;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | OCamlJavaException e) {
            Fail.invalidArgument("not an OCaml plugin");
            return Value.UNIT;
        }
    }

    private static final class Handle {
        private final ClassLoader classLoader;
        private final JarFile jarFile;
        private final Properties properties;

        private Handle(ClassLoader cl, JarFile jf, Properties p) {
            assert (cl != null) : "null cl";
            assert (jf != null) : "null jf";
            assert (p != null) : "null p";
            this.classLoader = cl;
            this.jarFile = jf;
            this.properties = p;
        }
    }
}

