/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.stdlib.Lexing;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Parsing", source="byterun/parsing.c")
public final class Parsing {
    private static final int ERRCODE = 256;
    private static final long ACTIONS = 0L;
    private static final long TRANSL_CONST = 1L;
    private static final long TRANSL_BLOCK = 2L;
    private static final long LHS = 3L;
    private static final long LEN = 4L;
    private static final long DEFRED = 5L;
    private static final long DGOTO = 6L;
    private static final long SINDEX = 7L;
    private static final long RINDEX = 8L;
    private static final long GINDEX = 9L;
    private static final long TABLESIZE = 10L;
    private static final long TABLE = 11L;
    private static final long CHECK = 12L;
    private static final long ERROR_FUNCTION = 13L;
    private static final long NAMES_CONST = 14L;
    private static final long NAMES_BLOCK = 15L;
    private static final long S_STACK = 0L;
    private static final long V_STACK = 1L;
    private static final long SYMB_START_STACK = 2L;
    private static final long SYMB_END_STACK = 3L;
    private static final long STACKSIZE = 4L;
    private static final long STACKBASE = 5L;
    private static final long CURR_CHAR = 6L;
    private static final long LVAL = 7L;
    private static final long SYMB_START = 8L;
    private static final long SYMB_END = 9L;
    private static final long ASP = 10L;
    private static final long RULE_LEN = 11L;
    private static final long RULE_NUMBER = 12L;
    private static final long SP = 13L;
    private static final long STATE = 14L;
    private static final long ERRFLAG = 15L;
    private static final int START = 0;
    private static final int TOKEN_READ = 1;
    private static final int STACKS_GROWN_1 = 2;
    private static final int STACKS_GROWN_2 = 3;
    private static final int SEMANTIC_ACTION_COMPUTED = 4;
    private static final int ERROR_DETECTED = 5;
    private static final Value READ_TOKEN = Value.ZERO;
    private static final Value RAISE_PARSE_ERROR = Value.ONE;
    private static final Value GROW_STACKS_1 = Value.TWO;
    private static final Value GROW_STACKS_2 = Value.THREE;
    private static final Value COMPUTE_SEMANTIC_ACTION = Value.FOUR;
    private static final Value CALL_ERROR_FUNCTION = Value.FIVE;
    private static final int NO_GOTO = 0;
    private static final int GOTO_LOOP = 1;
    private static final int GOTO_REDUCE = 2;
    private static final int GOTO_TESTSHIFT = 3;
    private static final int GOTO_SHIFT = 4;
    private static final int GOTO_RECOVER = 5;
    private static final int GOTO_SHIFT_RECOVER = 6;
    private static final int GOTO_PUSH = 7;
    private static final int GOTO_SEMANTIC_ACTION = 8;

    private Parsing() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Parsing.parse_tables", "Parsing.parse_env", "Parsing.parser_input", "Obj.t"}, returnType="Parsing.parser_output")
    public static Value caml_parse_engine(Value tables, Value env, Value cmd, Value arg) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        PrintStream err = ctxt.getCodeState().isParserTraceEnabled() ? new PrintStream(ctxt.getFilesState().getChannel(2).newOutputStream()) : null;
        int state = 0;
        int sp = 0;
        int asp = 0;
        int errFlag = 0;
        int n = 0;
        int n1 = 0;
        int n2 = 0;
        int m = 0;
        int state1 = 0;
        int gto = 0;
        switch (cmd.asCastedInt()) {
            case 0: {
                state = 0;
                sp = env.get(13L).asCastedInt();
                errFlag = 0;
                gto = 1;
                break;
            }
            case 1: {
                sp = env.get(13L).asCastedInt();
                state = env.get(14L).asCastedInt();
                errFlag = env.get(15L).asCastedInt();
                if (arg.isBlock()) {
                    env.set(6L, tables.get(2L).get(arg.getTag()));
                    env.set(7L, arg.get0());
                } else {
                    env.set(6L, tables.get(1L).get(arg.asLong()));
                    env.set(7L, Value.ZERO);
                }
                if (err != null) {
                    Parsing.printToken(err, tables, state, arg);
                }
                gto = 3;
                break;
            }
            case 5: {
                sp = env.get(13L).asCastedInt();
                state = env.get(14L).asCastedInt();
                errFlag = env.get(15L).asCastedInt();
                gto = 5;
                break;
            }
            case 2: {
                sp = env.get(13L).asCastedInt();
                state = env.get(14L).asCastedInt();
                errFlag = env.get(15L).asCastedInt();
                gto = 7;
                break;
            }
            case 3: {
                sp = env.get(13L).asCastedInt();
                state = env.get(14L).asCastedInt();
                errFlag = env.get(15L).asCastedInt();
                gto = 8;
                break;
            }
            case 4: {
                sp = env.get(13L).asCastedInt();
                state = env.get(14L).asCastedInt();
                errFlag = env.get(15L).asCastedInt();
                env.get(0L).set(sp, Value.createLong(state));
                env.get(1L).set(sp, arg);
                asp = env.get(10L).asCastedInt();
                env.get(3L).set(sp, env.get(3L).get(asp));
                if (sp > asp) {
                    env.get(2L).set(sp, env.get(3L).get(asp));
                }
                gto = 1;
                break;
            }
            default: {
                assert (false) : "invalid command";
                return RAISE_PARSE_ERROR;
            }
        }
        block18: while (true) {
            switch (gto) {
                case 1: {
                    n = Lexing.getShort(tables.get(5L), state);
                    if (n != 0) {
                        gto = 2;
                        continue block18;
                    }
                    if (env.get(6L).asCastedInt() < 0) {
                        env.set(13L, Value.createLong(sp));
                        env.set(14L, Value.createLong(state));
                        env.set(15L, Value.createLong(errFlag));
                        return READ_TOKEN;
                    }
                    gto = 3;
                    continue block18;
                }
                case 2: {
                    if (err != null) {
                        err.printf("State %d: reduce by rule %d\n", state, n);
                    }
                    m = Lexing.getShort(tables.get(4L), n);
                    env.set(10L, Value.createLong(sp));
                    env.set(12L, Value.createLong(n));
                    env.set(11L, Value.createLong(m));
                    sp = sp - m + 1;
                    m = Lexing.getShort(tables.get(3L), n);
                    state1 = env.get(0L).get(sp - 1).asCastedInt();
                    n1 = Lexing.getShort(tables.get(9L), m);
                    n2 = n1 + state1;
                    state = n1 != 0 && n2 >= 0 && n2 <= tables.get(10L).asCastedInt() && Lexing.getShort(tables.get(12L), n2) == state1 ? Lexing.getShort(tables.get(11L), n2) : Lexing.getShort(tables.get(6L), m);
                    if (sp >= env.get(4L).asCastedInt()) {
                        env.set(13L, Value.createLong(sp));
                        env.set(14L, Value.createLong(state));
                        env.set(15L, Value.createLong(errFlag));
                        return GROW_STACKS_2;
                    }
                    gto = 8;
                    continue block18;
                }
                case 3: {
                    n1 = Lexing.getShort(tables.get(7L), state);
                    n2 = n1 + env.get(6L).asCastedInt();
                    if (n1 != 0 && n2 >= 0 && (long)n2 <= tables.get(10L).asLong() && (long)Lexing.getShort(tables.get(12L), n2) == env.get(6L).asLong()) {
                        gto = 4;
                        continue block18;
                    }
                    n1 = Lexing.getShort(tables.get(8L), state);
                    n2 = n1 + env.get(6L).asCastedInt();
                    if (n1 != 0 && n2 >= 0 && n2 <= tables.get(10L).asCastedInt() && (long)Lexing.getShort(tables.get(12L), n2) == env.get(6L).asLong()) {
                        n = Lexing.getShort(tables.get(11L), n2);
                        gto = 2;
                        continue block18;
                    }
                    if (errFlag <= 0) {
                        env.set(13L, Value.createLong(sp));
                        env.set(14L, Value.createLong(state));
                        env.set(15L, Value.createLong(errFlag));
                        return CALL_ERROR_FUNCTION;
                    }
                    gto = 5;
                    continue block18;
                }
                case 4: {
                    env.set(6L, Value.MINUS_ONE);
                    if (errFlag > 0) {
                        --errFlag;
                    }
                    gto = 6;
                    continue block18;
                }
                case 5: {
                    if (errFlag < 3) {
                        errFlag = 3;
                        break;
                    }
                    if (env.get(6L).asCastedInt() == 0) {
                        return RAISE_PARSE_ERROR;
                    }
                    if (err != null) {
                        err.printf("Discarding last token read\n", new Object[0]);
                    }
                    env.set(6L, Value.MINUS_ONE);
                    gto = 1;
                    continue block18;
                }
                case 6: {
                    if (err != null) {
                        err.printf("State %d: shift to state %d\n", state, Lexing.getShort(tables.get(11L), n2));
                    }
                    state = Lexing.getShort(tables.get(11L), n2);
                    if (++sp >= env.get(4L).asCastedInt()) {
                        env.set(13L, Value.createLong(sp));
                        env.set(14L, Value.createLong(state));
                        env.set(15L, Value.createLong(errFlag));
                        return GROW_STACKS_1;
                    }
                    gto = 7;
                    continue block18;
                }
                case 7: {
                    env.get(0L).set(sp, Value.createLong(state));
                    env.get(1L).set(sp, env.get(7L));
                    env.get(2L).set(sp, env.get(8L));
                    env.get(3L).set(sp, env.get(9L));
                    gto = 1;
                    continue block18;
                }
                case 8: {
                    env.set(13L, Value.createLong(sp));
                    env.set(14L, Value.createLong(state));
                    env.set(15L, Value.createLong(errFlag));
                    return COMPUTE_SEMANTIC_ACTION;
                }
                default: {
                    assert (false) : "invalid goto";
                    return RAISE_PARSE_ERROR;
                }
            }
            while (true) {
                state1 = env.get(0L).get(sp).asCastedInt();
                n1 = Lexing.getShort(tables.get(7L), state1);
                n2 = n1 + 256;
                if (n1 != 0 && n2 >= 0 && n2 <= tables.get(10L).asCastedInt() && Lexing.getShort(tables.get(12L), n2) == 256) {
                    if (err != null) {
                        err.printf("Recovering in state %d\n", state1);
                    }
                    gto = 6;
                    gto = 4;
                    continue block18;
                }
                if (err != null) {
                    err.printf("Discarding state %d\n", state1);
                }
                if (sp <= env.get(5L).asCastedInt()) {
                    if (err != null) {
                        err.printf("No more states to discard\n", new Object[0]);
                    }
                    return RAISE_PARSE_ERROR;
                }
                --sp;
            }
            break;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="bool")
    public static Value caml_set_parser_trace(Value v) {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Value old = ctxt.getCodeState().isParserTraceEnabled() ? Value.TRUE : Value.FALSE;
        ctxt.getCodeState().setParserTrace(v != Value.FALSE);
        return old;
    }

    private static void printToken(PrintStream err, Value tables, int state, Value tok) {
        if (tok.isLong()) {
            err.printf("State %d: read token %s\n", state, Parsing.getTokenName(tables.get(14L), tok.asCastedInt()));
        } else {
            err.printf("State %d: read token %s(", state, Parsing.getTokenName(tables.get(15L), tok.getTag()));
            Value v = tok.get0();
            if (v.isLong()) {
                err.printf("%d", v.asLong());
            } else {
                switch (v.getTag()) {
                    case 252: {
                        err.print(v.asString());
                        break;
                    }
                    case 253: {
                        boolean exp;
                        StringBuilder sb = new StringBuilder();
                        Formatter fmt = new Formatter(sb, Locale.US);
                        fmt.format("%g", v.asDouble());
                        boolean bl = exp = sb.indexOf("e") >= 0 || sb.indexOf("E") >= 0;
                        if (!exp) {
                            while (sb.charAt(sb.length() - 1) == '0') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                        }
                        if (sb.charAt(sb.length() - 1) == '.') {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        err.print(sb.toString());
                        break;
                    }
                    default: {
                        err.print("_");
                    }
                }
            }
            err.printf(")\n", new Object[0]);
        }
    }

    private static String getTokenName(Value names, int idx) {
        int n;
        byte[] bytes = names.getBytes();
        int len = bytes.length;
        int p = 0;
        int n2 = n = idx <= 0 ? 0 : idx;
        if (n == 0) {
            int j;
            for (j = 1; j < len && bytes[j] != 0; ++j) {
            }
            return EncodingUtils.convertBytesToString(Arrays.copyOfRange(bytes, 0, j));
        }
        for (int i = 0; i < len; ++i) {
            int j;
            if (bytes[i] != 0 || n != ++p) continue;
            for (j = i + 1; j < len && bytes[j] != 0; ++j) {
            }
            return EncodingUtils.convertBytesToString(Arrays.copyOfRange(bytes, i + 1, j));
        }
        return "<unknown token>";
    }
}

