/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/pipe.c")
public final class Pipe {
    private Pipe() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Unix.file_descr * Unix.file_descr")
    public static Value unix_pipe(Value unit) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        try {
            PipedInputStream readStream = new PipedInputStream();
            PipedOutputStream writeStream = new PipedOutputStream(readStream);
            Channel readChannel = new Channel(readStream);
            Channel writeChannel = new Channel(writeStream);
            return Value.createBlock(0, Value.createLong(ctxt.getFilesState().addChannel(readChannel)), Value.createLong(ctxt.getFilesState().addChannel(writeChannel)));
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("pipe", ioe);
            return Value.UNIT;
        }
    }
}

