/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/accept.c")
public final class Accept {
    private Accept() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.file_descr * Unix.sockaddr")
    public static Value unix_accept(Value socket) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Channel ch = ctxt.getFilesState().getChannel(socket.asCastedInt());
        if (ch == null) {
            Unix.fail("accept", "invalid descriptor");
            return Value.UNIT;
        }
        ServerSocketChannel serv = ch.asServerSocket();
        if (serv == null) {
            Unix.fail("accept", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            ctxt.enterBlockingSection();
            SocketChannel s = serv.accept();
            ctxt.leaveBlockingSection();
            int fd = ctxt.getFilesState().addChannel(new Channel(s));
            Value res = Value.createBlock(0, Value.createLong(fd), Unix.createSockAddr((InetSocketAddress)s.getRemoteAddress()));
            return res;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            ctxt.leaveBlockingSection();
            Unix.fail("accept", ioe);
            return Value.UNIT;
        }
    }
}

