/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Lock", source="")
public final class Lock {
    private Lock() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"bool"}, returnType="Lock.t")
    public static Value ocamljava_lock_make_reentrant(Value fair) {
        return Value.createInstance(new ReentrantLock(fair != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_lock(Value obj) {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        inst.lock();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_lock_interruptibly(Value obj) throws Fail.Exception {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        try {
            inst.lockInterruptibly();
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Fail.failWith("Lock.try_lock_interruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="Condition.t")
    public static Value ocamljava_lock_new_condition(Value obj) {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        Condition res = inst.newCondition();
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="bool")
    public static Value ocamljava_lock_try_lock(Value obj) {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        boolean res = inst.tryLock();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_lock_try_lock_time(Value obj, Value time, Value unit) throws Fail.Exception {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        try {
            boolean res = inst.tryLock(time.asInt64(), TimeUnit.decode(unit));
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (InterruptedException ie) {
            Fail.failWith("Lock.try_lock");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_unlock(Value obj) {
        java.util.concurrent.locks.Lock inst = (java.util.concurrent.locks.Lock)obj.asCustom();
        inst.unlock();
        return Value.UNIT;
    }
}

