/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.externallibs.zip;

import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.externallibs.zip.ZStream;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="zip", module="ZLib", source="zlibstubs.c")
public final class Zlib {
    private static final Value Z_NO_FLUSH = Value.ZERO;
    private static final Value Z_SYNC_FLUSH = Value.ONE;
    private static final Value Z_FULL_FLUSH = Value.TWO;
    private static final Value Z_FINISH = Value.THREE;
    private static final int[] CRC_TABLE = new int[256];

    private Zlib() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "bool"}, returnType="Zlib.stream")
    public static Value camlzip_deflateInit(Value level, Value header) throws Fail.Exception {
        try {
            return ZStream.create(new Deflater(level.asCastedInt(), header == Value.FALSE), null);
        }
        catch (Exception e) {
            Zlib.error("Zlib.deflateInit", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter only supports [Z_FINISH]"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int"}, returnType="Zlib.flush_command")
    public static Value camlzip_deflate(Value stream, Value srcBuff, Value srcPos, Value srcLen, Value dstBuff, Value dstPos, Value dstLen, Value flush) throws Fail.Exception {
        return Zlib.camlzip_deflate_bytecode(stream, srcBuff, srcPos, srcLen, dstBuff, dstPos, dstLen, flush);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter only supports [Z_FINISH]"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int"}, returnType="Zlib.flush_command")
    public static Value camlzip_deflate_bytecode(Value stream, Value srcBuff, Value srcPos, Value srcLen, Value dstBuff, Value dstPos, Value dstLen, Value flush) throws Fail.Exception {
        try {
            Deflater d = ((ZStream)stream.asCustom()).getDeflater();
            long read = d.getBytesRead();
            d.setInput(srcBuff.getBytes(), srcPos.asBoundedInt(), srcLen.asBoundedInt());
            if (flush == Z_FINISH) {
                d.finish();
            }
            int written = d.deflate(dstBuff.getBytesForModification(), dstPos.asBoundedInt(), dstLen.asBoundedInt());
            return Value.createBlock(0, d.finished() ? Value.TRUE : Value.FALSE, Value.createLong(d.getBytesRead() - read), Value.createLong(written));
        }
        catch (Exception e) {
            Zlib.error("Zlib.deflate", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Zlib.stream"}, returnType="unit")
    public static Value camlzip_deflateEnd(Value stream) throws Fail.Exception {
        try {
            ((ZStream)stream.asCustom()).getDeflater().end();
            return Value.UNIT;
        }
        catch (Exception e) {
            Zlib.error("Zlib.deflateEnd", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="Zlib.stream")
    public static Value camlzip_inflateInit(Value header) throws Fail.Exception {
        try {
            return ZStream.create(null, new Inflater(header == Value.FALSE));
        }
        catch (Exception e) {
            Zlib.error("Zlib.inflateInit", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter is ignored"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_inflate(Value stream, Value srcBuff, Value srcPos, Value srcLen, Value dstBuff, Value dstPos, Value dstLen, Value flush) throws Fail.Exception {
        return Zlib.camlzip_inflate_bytecode(stream, srcBuff, srcPos, srcLen, dstBuff, dstPos, dstLen, flush);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter is ignored"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_inflate_bytecode(Value stream, Value srcBuff, Value srcPos, Value srcLen, Value dstBuff, Value dstPos, Value dstLen, Value flush) throws Fail.Exception {
        try {
            Inflater i = ((ZStream)stream.asCustom()).getInflater();
            long read = i.getBytesRead();
            i.setInput(srcBuff.getBytes(), srcPos.asBoundedInt(), srcLen.asBoundedInt());
            int written = i.inflate(dstBuff.getBytesForModification(), dstPos.asBoundedInt(), dstLen.asBoundedInt());
            return Value.createBlock(0, i.finished() ? Value.TRUE : Value.FALSE, Value.createLong(i.getBytesRead() - read), Value.createLong(written));
        }
        catch (Exception e) {
            Zlib.error("Zlib.inflate", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Zlib.stream"}, returnType="unit")
    public static Value camlzip_inflateEnd(Value stream) throws Fail.Exception {
        try {
            ((ZStream)stream.asCustom()).getInflater().end();
            return Value.UNIT;
        }
        catch (Exception e) {
            Zlib.error("Zlib.inflateEnd", e);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int32", "string", "int", "int"}, returnType="int32")
    public static Value camlzip_update_crc32(Value crc, Value buff, Value pos, Value len) throws Fatal.Exception {
        int c = ~crc.asInt32();
        int l = len.asBoundedInt();
        int ofs = pos.asBoundedInt();
        byte[] b = buff.getBytes();
        for (int i = 0; i < l; ++i) {
            c = CRC_TABLE[(c ^ b[ofs + i]) & 0xFF] ^ c >>> 8;
        }
        return Value.createInt32(~c);
    }

    private static void error(String prim, Exception e) throws Fail.Exception {
        assert (prim != null) : "null prim";
        assert (e != null) : "null e";
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Value camlzipException = ctxt.getCodeState().getCallback("Zlib.Error");
        if (camlzipException == null) {
            Fail.invalidArgument("Exception Zlib.Error not initialized");
        } else {
            String msg = e.getMessage();
            Value bucket = Value.createBlock(0, camlzipException, Value.createString(prim), Value.createString(msg != null ? msg : ""));
            Fail.raise(bucket);
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int tmp = i;
            for (int j = 0; j < 8; ++j) {
                tmp = (tmp & 1) != 0 ? 0xEDB88320 ^ tmp >>> 1 : (tmp >>>= 1);
                Zlib.CRC_TABLE[i] = tmp;
            }
        }
    }
}

