/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class LargeStringValue
extends BlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private byte[][] bytes;

    LargeStringValue(long sz) {
        super(252, (sz + 8L) / 8L);
        assert (sz >= 0L) : "sz should be >= 0";
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = this.length << 1 | 1L;
        this.sizeMinusOneTagged = this.length - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(this.length);
        this.bytes = new byte[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.bytes[i] = new byte[Integer.MIN_VALUE];
        }
        this.bytes[len - 1] = new byte[lenLast];
    }

    LargeStringValue(long sz, String s) {
        this(sz);
        assert (sz >= 0L) : "sz should be >= 0";
        assert (s != null) : "null s";
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.setByte(i, EncodingUtils.convertCharToByte(s.charAt(i)));
        }
    }

    LargeStringValue(long sz, byte[] s) {
        this(sz);
        assert (sz >= 0L) : "sz should be >= 0";
        assert (s != null) : "null s";
        int l = s.length;
        for (int i = 0; i < l; ++i) {
            this.setByte(i, s[i]);
        }
    }

    @Override
    public synchronized String asString() {
        StringBuilder res = new StringBuilder();
        int len = (int)Math.min(this.length, 0x7FFFFFFEL);
        for (int i = 0; i < len; ++i) {
            res.append(EncodingUtils.convertByteToChar(this.getByte(i)));
        }
        return res.toString();
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public synchronized byte[] getBytesForModification() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        if (idx == this.length) {
            return 0;
        }
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return this.bytes[idx1][idx2];
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.bytes[idx1][idx2] = x;
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        return IntegerUtils.signedToUnsignedByte(this.getByte(idx));
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        this.setByte(idx, (byte)IntegerUtils.unsignedToSignedByte(x & 0xFF));
    }

    @Override
    public long sizeBytes() {
        return this.length;
    }

    @Override
    public long sizeBytesTagged() {
        return this.sizeTagged;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value sizeBytesWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long s) {
        long sz = s * 8L;
        byte[][] oldBytes = this.bytes;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.bytes = new byte[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.bytes[i] = new byte[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.bytes[i][j] = oldBytes[i][j];
            }
        }
        this.bytes[len - 1] = new byte[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.bytes[len - 1][j] = oldBytes[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeValues());
        for (long i = 0L; i < len; ++i) {
            this.setByte(i, src.getByte(i));
        }
    }

    @Override
    public LargeStringValue duplicate() {
        long len = this.length;
        LargeStringValue res = new LargeStringValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setByte(i, this.getByte(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        int res = 0;
        byte[] v = this.bytes[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += v[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeStringValue) {
            LargeStringValue that = (LargeStringValue)obj;
            int lenThis = this.bytes.length;
            int lenThat = that.bytes.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.bytes[i], that.bytes[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeStringValue(");
        int len = this.bytes.length;
        for (int i = 0; i < len; ++i) {
            int l = this.bytes[i].length;
            for (int j = 0; j < l; ++j) {
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append(this.bytes[i][j]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

