/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.InputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.OutputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.ParameterComponents;
import org.ocamljava.runtime.annotations.parameters.SimpleParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.util.ShellUtils;

public final class Parameters {
    private static final String SHORT_ARG_PREFIX = "-";
    private static final String LONG_ARG_PREFIX = "--";
    private static final String ARG_SEPARATOR = "=";
    private static final String DIALOG_TITLE = "Interpreter parameters";
    private static final int DIALOG_BORDER = 16;

    private Parameters() {
    }

    public static ByteCodeParameters defaultByteCodeParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object proxy = Parameters.newProxyInstance(ByteCodeParameters.class, map, null);
        return (ByteCodeParameters)proxy;
    }

    public static NativeParameters defaultNativeParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object proxy = Parameters.newProxyInstance(NativeParameters.class, map, null);
        return (NativeParameters)proxy;
    }

    public static ByteCodeParameters fromArray(String[] args, File dir) throws ParameterException {
        assert (args != null) : "null args";
        Method[] methods = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int len = args.length;
        int idx = 0;
        while (idx < len && args[idx].startsWith(SHORT_ARG_PREFIX)) {
            boolean incr;
            String value;
            String name;
            if (args[idx].startsWith(LONG_ARG_PREFIX)) {
                String[] parts;
                if ((parts = args[idx++].split(ARG_SEPARATOR)).length > 2) {
                    throw new ParameterException("invalid switch format");
                }
                name = parts[0].substring(LONG_ARG_PREFIX.length());
                value = parts.length > 1 ? parts[1] : null;
                incr = false;
            } else {
                name = args[idx++].substring(SHORT_ARG_PREFIX.length());
                value = idx < len ? args[idx] : null;
                incr = true;
            }
            if ("".equals(name)) {
                throw new ParameterException("invalid switch name");
            }
            boolean found = false;
            for (Method m : methods) {
                if (!name.equals(Parameters.getCommandLineSwitch(m))) continue;
                found = true;
                map.put(Parameters.getKey(m), Parameters.convertValue(value, m));
                if (!incr || m.getAnnotation(SimpleParameter.class) != null) break;
                ++idx;
                break;
            }
            if (found) continue;
            throw new ParameterException(String.format("unknown switch '%s'", name));
        }
        map.put("FILE", idx < len ? args[idx] : null);
        int rem = len - idx;
        String[] appArgs = new String[rem];
        System.arraycopy(args, idx, appArgs, 0, rem);
        if (dir != null) {
            try {
                appArgs = ShellUtils.expandCommandLine(dir, appArgs);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        map.put("ARGUMENTS", appArgs);
        Object proxy = Parameters.newProxyInstance(ByteCodeParameters.class, map, null);
        return (ByteCodeParameters)proxy;
    }

    public static ByteCodeParameters fromProperties(Properties p) throws ParameterException {
        Method[] methods = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            for (Method m : methods) {
                if (!e.getKey().equals(Parameters.getCommandLineSwitch(m))) continue;
                map.put(Parameters.getKey(m), Parameters.convertValue((String)e.getValue(), m));
            }
        }
        Object proxy = Parameters.newProxyInstance(ByteCodeParameters.class, map, null);
        return (ByteCodeParameters)proxy;
    }

    public static NativeParameters fromStream(InputStream is, String[] args, InputStream in, PrintStream out, PrintStream err, boolean bareCanvas, String file, Class<?> base) throws OCamlJavaException {
        assert (is != null) : "null is";
        assert (args != null) : "null args";
        assert (in != null) : "null in";
        assert (out != null) : "null out";
        assert (err != null) : "null err";
        assert (file != null) : "null file";
        assert (base != null) : "null base";
        try {
            String filePath;
            Properties p = new Properties();
            p.load(is);
            Method[] methods = NativeParameters.class.getMethods();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                for (Method m : methods) {
                    String k = Parameters.getCommandLineSwitch(m);
                    if (!e.getKey().equals(k)) continue;
                    map.put(Parameters.getKey(m), Parameters.convertValue((String)e.getValue(), m));
                }
            }
            int len = args.length;
            String[] argsWithFile = new String[len + 1];
            System.arraycopy(args, 0, argsWithFile, 1, len);
            try {
                filePath = base.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toString();
            }
            catch (Throwable t) {
                filePath = file;
            }
            argsWithFile[0] = filePath;
            map.put("ARGUMENTS", argsWithFile);
            map.put("IN", in);
            map.put("OUT", out);
            map.put("ERR", err);
            map.put("BARE_CANVAS", bareCanvas ? Boolean.TRUE : Boolean.FALSE);
            map.put("FILE", file);
            Object proxy = Parameters.newProxyInstance(NativeParameters.class, map, null);
            return (NativeParameters)proxy;
        }
        catch (IOException ioe) {
            throw new OCamlJavaException("unable to load parameters", ioe);
        }
    }

    public static ByteCodeParameters fromDialog(ByteCodeParameters bcp) throws ParameterException {
        assert (bcp != null) : "null bcp";
        Method[] methods = ByteCodeParameters.class.getMethods();
        int count = 0;
        for (Method m : methods) {
            String lbl = Parameters.getGUILabel(m);
            if (lbl == null || lbl.equals("")) continue;
            ++count;
        }
        final JDialog dlg = new JDialog((Frame)null, DIALOG_TITLE, true);
        dlg.setDefaultCloseOperation(3);
        JPanel parametersPanel = new JPanel(new GridLayout(count, 2, 4, 4));
        JComponent[] components = new JComponent[count];
        int i = 0;
        for (Method m : methods) {
            String lbl = Parameters.getGUILabel(m);
            if (lbl == null || lbl.equals("")) continue;
            JComponent comp = ParameterComponents.createComponent(m, bcp);
            parametersPanel.add(new JLabel(lbl, 4));
            parametersPanel.add(comp);
            components[i++] = comp;
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dlg.setVisible(false);
            }
        });
        buttonPanel.add(Box.createHorizontalGlue(), "Center");
        buttonPanel.add((Component)okButton, "East");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)parametersPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        Container cont = dlg.getContentPane();
        cont.add(Box.createVerticalStrut(16), "North");
        cont.add(Box.createVerticalStrut(16), "South");
        cont.add(Box.createHorizontalStrut(16), "East");
        cont.add(Box.createHorizontalStrut(16), "West");
        cont.add((Component)mainPanel, "Center");
        dlg.pack();
        dlg.setResizable(false);
        dlg.setVisible(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int j = 0;
        for (Method m : methods) {
            String lbl = Parameters.getGUILabel(m);
            if (lbl == null || lbl.equals("")) continue;
            JComponent comp = components[j++];
            map.put(Parameters.getKey(m), ParameterComponents.readComponentValue(m, comp));
        }
        Object proxy = Parameters.newProxyInstance(ByteCodeParameters.class, map, bcp);
        return (ByteCodeParameters)proxy;
    }

    public static ByteCodeParameters setFile(ByteCodeParameters bcp, String value) {
        assert (bcp != null) : "null bcp";
        return Parameters.setByteCodeParameter(bcp, "FILE", value);
    }

    public static NativeParameters setFile(NativeParameters np, String value) {
        assert (np != null) : "null np";
        return Parameters.setNativeParameter(np, "FILE", value);
    }

    public static ByteCodeParameters setUnparsedElements(ByteCodeParameters bcp, String[] value) {
        assert (bcp != null) : "null bcp";
        assert (value != null) : "null value";
        return Parameters.setByteCodeParameter(bcp, "ARGUMENTS", value);
    }

    public static NativeParameters setUnparsedElements(NativeParameters np, String[] value) {
        assert (np != null) : "null np";
        assert (value != null) : "null value";
        return Parameters.setNativeParameter(np, "ARGUMENTS", value);
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters bcp, CommonParameters.BooleanParameterID id, boolean value) {
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static NativeParameters setBooleanParameter(NativeParameters np, CommonParameters.BooleanParameterID id, boolean value) {
        assert (np != null) : "null np";
        assert (id != null) : "null id";
        return Parameters.setNativeParameter(np, id.name(), value);
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters bcp, ByteCodeParameters.BooleanParameterID id, boolean value) {
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static NativeParameters setBooleanParameter(NativeParameters np, NativeParameters.BooleanParameterID id, boolean value) {
        assert (np != null) : "null np";
        assert (id != null) : "null id";
        return Parameters.setNativeParameter(np, id.name(), value);
    }

    public static ByteCodeParameters setIntegerParameter(ByteCodeParameters bcp, ByteCodeParameters.IntegerParameterID id, int value) throws ParameterException {
        Method[] methods;
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        for (Method m : methods = ByteCodeParameters.class.getMethods()) {
            IntegerParameter ip;
            if (!id.name().equals(Parameters.getKey(m)) || value >= (ip = m.getAnnotation(IntegerParameter.class)).minValue() || value <= ip.maxValue()) continue;
            throw new ParameterException("integer value out of range");
        }
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static ByteCodeParameters setStringParameter(ByteCodeParameters bcp, CommonParameters.StringParameterID id, String value) throws ParameterException {
        Method[] methods;
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        for (Method m : methods = ByteCodeParameters.class.getMethods()) {
            int i;
            if (!id.name().equals(Parameters.getKey(m))) continue;
            StringParameter ip = m.getAnnotation(StringParameter.class);
            String[] values = ip.possibleValues();
            int l = values.length;
            for (i = 0; i < l && !values[i].equals(value); ++i) {
            }
            if (l <= 0 || i != l) continue;
            throw new ParameterException("invalid string value");
        }
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static NativeParameters setStringParameter(NativeParameters np, CommonParameters.StringParameterID id, String value) throws ParameterException {
        Method[] methods;
        assert (np != null) : "null np";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        for (Method m : methods = ByteCodeParameters.class.getMethods()) {
            int i;
            if (!id.name().equals(Parameters.getKey(m))) continue;
            StringParameter ip = m.getAnnotation(StringParameter.class);
            String[] values = ip.possibleValues();
            int l = values.length;
            for (i = 0; i < l && !values[i].equals(value); ++i) {
            }
            if (l <= 0 || i != l) continue;
            throw new ParameterException("invalid string value");
        }
        return Parameters.setNativeParameter(np, id.name(), value);
    }

    public static ByteCodeParameters setInputStreamParameter(ByteCodeParameters bcp, CommonParameters.InputStreamParameterID id, InputStream value) {
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static NativeParameters setInputStreamParameter(NativeParameters np, CommonParameters.InputStreamParameterID id, InputStream value) {
        assert (np != null) : "null np";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        return Parameters.setNativeParameter(np, id.name(), value);
    }

    public static ByteCodeParameters setPrintStreamParameter(ByteCodeParameters bcp, CommonParameters.PrintStreamParameterID id, PrintStream value) {
        assert (bcp != null) : "null bcp";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        return Parameters.setByteCodeParameter(bcp, id.name(), value);
    }

    public static NativeParameters setPrintStreamParameter(NativeParameters np, CommonParameters.PrintStreamParameterID id, PrintStream value) {
        assert (np != null) : "null np";
        assert (id != null) : "null id";
        assert (value != null) : "null value";
        return Parameters.setNativeParameter(np, id.name(), value);
    }

    private static ByteCodeParameters setByteCodeParameter(ByteCodeParameters bcp, String name, Object value) {
        assert (bcp != null) : "null bcp";
        assert (name != null) : "null name";
        return (ByteCodeParameters)Parameters.setParameter(bcp, ByteCodeParameters.class, name, value);
    }

    private static NativeParameters setNativeParameter(NativeParameters np, String name, Object value) {
        assert (np != null) : "null np";
        assert (name != null) : "null name";
        return (NativeParameters)Parameters.setParameter(np, NativeParameters.class, name, value);
    }

    private static Object setParameter(Object params, Class<?> cls, String name, Object value) {
        assert (params != null) : "null params";
        assert (cls != null) : "null cls";
        assert (name != null) : "null name";
        try {
            MapProxy old = (MapProxy)Proxy.getInvocationHandler(params);
            HashMap<String, Object> map = new HashMap<String, Object>(old.values);
            map.put(name, value);
            Object proxy = Parameters.newProxyInstance(cls, map, old.fallbackInstance);
            return proxy;
        }
        catch (Throwable t) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(name, value);
            Object proxy = Parameters.newProxyInstance(cls, map, params);
            return proxy;
        }
    }

    public static void printUsage(boolean latex, PrintStream out) {
        String suffix;
        String infix;
        String prefix;
        assert (out != null) : "null out";
        if (latex) {
            out.println("\\begin{enumerate}");
        } else {
            out.printf("OCaml-Java version %s (c) %s, %s\n", "2.0-early-access2", "Xavier Clerc", "2007-2012");
            out.printf("homepage: %s -- contact: %s\n", "http://www.ocamljava.org", "xclerc@ocamljava.org");
            out.println("usage: <interpreter arguments> <filename> <application arguments>");
            out.println("possible interpreter arguments:");
        }
        if (latex) {
            prefix = "  \\item[] \\texttt{";
            infix = "} or \\texttt{";
            suffix = "} \\\\";
        } else {
            prefix = "  ";
            infix = "\n  ";
            suffix = "";
        }
        Method[] methods = ByteCodeParameters.class.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                String cls1 = Parameters.getCommandLineSwitch(m1);
                String ncls1 = cls1 != null ? cls1 : "";
                String cls2 = Parameters.getCommandLineSwitch(m2);
                String ncls2 = cls2 != null ? cls2 : "";
                return ncls1.compareTo(ncls2);
            }
        });
        for (Method m : methods) {
            StringParameter sp;
            IntegerParameter ip;
            BooleanParameter bp;
            SimpleParameter p = m.getAnnotation(SimpleParameter.class);
            if (p != null && !p.commandLineSwitch().equals("")) {
                out.printf("%s-%s%s--%s%s\n", prefix, p.commandLineSwitch(), infix, p.commandLineSwitch(), suffix);
                out.printf("        %s\n", p.description());
            }
            if ((bp = m.getAnnotation(BooleanParameter.class)) != null && !bp.commandLineSwitch().equals("")) {
                out.printf("%s-%s <on|off>%s--%s=<on|off>  default:%s%s\n", prefix, bp.commandLineSwitch(), infix, bp.commandLineSwitch(), bp.defaultValue() ? "on" : "off", suffix);
                out.printf("        %s\n", bp.description());
            }
            if ((ip = m.getAnnotation(IntegerParameter.class)) != null && !ip.commandLineSwitch().equals("")) {
                out.printf("%s-%s <integer>%s--%s=<integer>  default:%d%s\n", prefix, ip.commandLineSwitch(), infix, ip.commandLineSwitch(), ip.defaultValue(), suffix);
                out.printf("        %s\n", ip.description());
            }
            if ((sp = m.getAnnotation(StringParameter.class)) == null || sp.commandLineSwitch().equals("")) continue;
            String defaultValue = sp.defaultValue();
            out.printf("%s-%s <%s>%s--%s=<%s>%s%s\n", prefix, sp.commandLineSwitch(), sp.argumentDescription(), infix, sp.commandLineSwitch(), sp.argumentDescription(), defaultValue.equals("") ? "" : "  default:" + defaultValue, suffix);
            out.printf("        %s\n", sp.description());
        }
        if (latex) {
            out.println("\\end{enumerate}");
        }
    }

    private static Object getDefaultValue(Method m) {
        SimpleParameter p = m.getAnnotation(SimpleParameter.class);
        if (p != null) {
            return Boolean.FALSE;
        }
        InputStreamParameter isp = m.getAnnotation(InputStreamParameter.class);
        if (isp != null) {
            return System.in;
        }
        OutputStreamParameter osp = m.getAnnotation(OutputStreamParameter.class);
        if (osp != null) {
            return osp.isErrorOutput() ? System.err : System.out;
        }
        Object res = Parameters.getAnnotationValue(m.getDeclaredAnnotations(), "defaultValue");
        return res;
    }

    private static String getKey(Method m) {
        assert (m != null) : "null m";
        return (String)Parameters.getAnnotationValue(m.getDeclaredAnnotations(), "key");
    }

    private static String getGUILabel(Method m) {
        assert (m != null) : "null m";
        return (String)Parameters.getAnnotationValue(m.getDeclaredAnnotations(), "guiLabel");
    }

    private static String getCommandLineSwitch(Method m) {
        assert (m != null) : "null m";
        return (String)Parameters.getAnnotationValue(m.getDeclaredAnnotations(), "commandLineSwitch");
    }

    private static Object getAnnotationValue(Annotation[] annots, String methodName) {
        assert (annots != null) : "null annots";
        assert (methodName != null) : "null methodName";
        Object res = null;
        for (Annotation annot : annots) {
            try {
                res = annot.getClass().getMethod(methodName, new Class[0]).invoke((Object)annot, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                // empty catch block
            }
        }
        return res;
    }

    private static Object convertValue(String value, Method meth) throws ParameterException {
        assert (meth != null) : "null meth";
        if (meth.getAnnotation(BooleanParameter.class) != null) {
            return Parameters.convertBoolean(value);
        }
        if (meth.getAnnotation(IntegerParameter.class) != null) {
            IntegerParameter ip = meth.getAnnotation(IntegerParameter.class);
            int res = Parameters.convertInteger(value);
            if (res < ip.minValue() && res > ip.maxValue()) {
                throw new ParameterException("integer value out of range");
            }
            return res;
        }
        if (meth.getAnnotation(SimpleParameter.class) != null) {
            return Boolean.TRUE;
        }
        if (meth.getAnnotation(StringParameter.class) != null) {
            int i;
            String[] values = meth.getAnnotation(StringParameter.class).possibleValues();
            int l = values.length;
            for (i = 0; i < l && !values[i].equals(value); ++i) {
            }
            if (l == 0 || i < l) {
                return value;
            }
            throw new ParameterException("invalid string value");
        }
        throw new ParameterException("unsuppoted parameter");
    }

    private static Boolean convertBoolean(String value) throws ParameterException {
        if ("on".equals(value)) {
            return Boolean.TRUE;
        }
        if ("off".equals(value)) {
            return Boolean.FALSE;
        }
        throw new ParameterException("switch value should be either 'on' or 'off'");
    }

    private static Integer convertInteger(String value) throws ParameterException {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new ParameterException("switch value should be an integer");
        }
    }

    private static Object newProxyInstance(Class<?> cls, Map<String, Object> map, Object inst) {
        assert (cls != null) : "null cls";
        assert (map != null) : "null map";
        return Proxy.newProxyInstance(Parameters.class.getClassLoader(), new Class[]{cls}, (InvocationHandler)new MapProxy(map, inst));
    }

    private static final class MapProxy
    implements InvocationHandler {
        private final Map<String, Object> values;
        private final Object fallbackInstance;

        private MapProxy(Map<String, Object> v, Object fi) {
            assert (v != null) : "null v";
            this.values = v;
            this.fallbackInstance = fi;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null || args.length == 0) {
                Object mapRes = this.values.get(Parameters.getKey(method));
                if (mapRes == null) {
                    try {
                        return method.invoke(this.fallbackInstance, new Object[0]);
                    }
                    catch (Throwable t) {
                        return Parameters.getDefaultValue(method);
                    }
                }
                return mapRes;
            }
            throw new IllegalArgumentException("Parameter methods take no parameter");
        }
    }
}

