/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class StringValue
extends BlockValue {
    private static final int MAX_CACHED_SIZE = 1024;
    private long size;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private byte[] bytes;
    private String cache;

    StringValue(long len) {
        super(252, (len + 8L) / 8L);
        assert (len >= 0L) : "len should be >= 0";
        this.bytes = new byte[(int)len];
        this.size = len;
        this.sizeTagged = len << 1 | 1L;
        this.sizeMinusOneTagged = len - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(len);
        this.cache = null;
    }

    StringValue(long len, String s) {
        this(len);
        assert (len >= 0L) : "len should be >= 0";
        assert (s != null) : "null s";
        int l = s.length();
        if ((long)l <= len) {
            EncodingUtils.convertStringToBytes(s, this.bytes, 0);
        } else {
            EncodingUtils.convertStringToBytes(s.substring(0, (int)len), this.bytes, 0);
        }
        if ((long)l == len) {
            this.cache = s;
        }
    }

    StringValue(long len, byte[] s) {
        this(len);
        assert (len >= 0L) : "len should be >= 0";
        assert (s != null) : "null s";
        this.bytes = s;
    }

    StringValue(byte[] s) {
        this((long)s.length, s);
    }

    StringValue(String s) {
        this((long)s.length(), s);
    }

    @Override
    public synchronized String asString() {
        if (this.cache == null) {
            String res = EncodingUtils.convertBytesToString(this.bytes);
            if (this.bytes.length <= 1024) {
                this.cache = res;
            }
            return res;
        }
        return this.cache;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public synchronized byte[] getBytesForModification() {
        this.cache = null;
        return this.bytes;
    }

    @Override
    public int[] getUnsignedBytes() {
        int len = this.bytes.length;
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.bytes[i] & 0xFF;
        }
        return res;
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        if (idx == (long)this.bytes.length) {
            return 0;
        }
        return this.bytes[(int)idx];
    }

    @Override
    public synchronized void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        this.bytes[(int)idx] = x;
        this.cache = null;
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        return this.getByte(idx) & 0xFF;
    }

    @Override
    public synchronized void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        this.setByte(idx, (byte)IntegerUtils.unsignedToSignedByte(x & 0xFF));
        this.cache = null;
    }

    @Override
    public long sizeBytes() {
        return this.size;
    }

    @Override
    public long sizeBytesTagged() {
        return this.sizeTagged;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value sizeBytesWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        this.bytes = Arrays.copyOf(this.bytes, (int)(sz * 8L));
        this.size = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public synchronized void copy(BlockValue src) {
        int len = (int)Math.min((long)this.bytes.length, src.sizeBytes());
        for (int i = 0; i < len; ++i) {
            this.bytes[i] = src.getByte(i);
        }
        this.cache = null;
    }

    @Override
    public StringValue duplicate() {
        StringValue res = new StringValue(Arrays.copyOf(this.bytes, this.bytes.length));
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.bytes.length);
        for (int i = 0; i < len; ++i) {
            res += 31 * this.bytes[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue that = (StringValue)obj;
            return Arrays.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringValue(");
        sb.append(this.asString());
        sb.append(")");
        return sb.toString();
    }
}

