/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class LargeBasicBlockValue
extends AbstractBasicBlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private Value[][] values;

    LargeBasicBlockValue(int tag, long sz) {
        super(tag, sz);
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.values = new Value[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new Value[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = Value.ZERO;
            }
        }
        this.values[len - 1] = new Value[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = Value.ZERO;
        }
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return this.values[idx1][idx2];
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[0][idx];
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.values[idx1][idx2] = x;
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[0][idx] = x;
    }

    @Override
    public long sizeValues() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        Value[][] oldValues = this.values;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.values = new Value[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new Value[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = oldValues[i][j];
            }
        }
        this.values[len - 1] = new Value[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = oldValues[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeValues());
        for (long i = 0L; i < len; ++i) {
            this.set(i, src.get(i));
        }
    }

    @Override
    public LargeBasicBlockValue duplicate() {
        long len = this.length;
        LargeBasicBlockValue res = new LargeBasicBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.set(i, this.get(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[i] = this.get(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.get(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        LargeBasicBlockValue res = new LargeBasicBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.set(i, this.get(i + ofs));
        }
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        Value[] v = this.values[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += v[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeBasicBlockValue) {
            LargeBasicBlockValue that = (LargeBasicBlockValue)obj;
            int lenThis = this.values.length;
            int lenThat = that.values.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.values[i], that.values[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeBasicBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            int l = this.values[i].length;
            for (int j = 0; j < l; ++j) {
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append(this.values[i][j]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

