/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.Value;

public final class LongValue
extends Value {
    private final long value;
    private final long raw;

    LongValue(long v, long r) {
        this.value = v;
        this.raw = r;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isCodeOffset() {
        return false;
    }

    @Override
    public boolean isMethodHandle() {
        return false;
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public boolean isDoubleArray() {
        return false;
    }

    @Override
    public boolean isLongBlock() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public long getRawValue() {
        return this.raw;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public long asCodeOffset() {
        return this.value;
    }

    @Override
    public int switchTag() {
        return (int)this.value;
    }

    @Override
    public LongValue duplicate() {
        return this;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongValue) {
            LongValue that = (LongValue)obj;
            return this.value == that.value;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongValue(");
        sb.append(this.value);
        sb.append(")");
        return sb.toString();
    }
}

