/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.AbstractLongBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class LargeLongBlockValue
extends AbstractLongBlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private long[][] values;

    LargeLongBlockValue(int tag, long sz) {
        super(tag, sz);
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.values = new long[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new long[Integer.MIN_VALUE];
        }
        this.values[len - 1] = new long[lenLast];
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return this.values[idx1][idx2];
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[0][idx];
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.values[idx1][idx2] = x;
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[0][idx] = x;
    }

    @Override
    public long sizeLongs() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        long[][] oldValues = this.values;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.values = new long[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new long[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = oldValues[i][j];
            }
        }
        this.values[len - 1] = new long[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = oldValues[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeLongs());
        for (long i = 0L; i < len; ++i) {
            this.setRawLong(i, src.getRawLong(i));
        }
    }

    @Override
    public LargeLongBlockValue duplicate() {
        long len = this.length;
        LargeLongBlockValue res = new LargeLongBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.setRawLong(i, this.getRawLong(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getRawLong(i);
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getRawLong(i);
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        LargeLongBlockValue res = new LargeLongBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.setRawLong(i, this.getRawLong(i + ofs));
        }
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        long[] v = this.values[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += (int)v[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeLongBlockValue) {
            LargeLongBlockValue that = (LargeLongBlockValue)obj;
            int lenThis = this.values.length;
            int lenThat = that.values.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.values[i], that.values[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeLongBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            int l = this.values[i].length;
            for (int j = 0; j < l; ++j) {
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append(this.values[i][j]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

