/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class BasicBlockValue
extends AbstractBasicBlockValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private Value[] values;

    BasicBlockValue(int tag, int sz) {
        super(tag, sz);
        this.values = new Value[sz];
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
        for (int i = 0; i < sz; ++i) {
            this.values[i] = Value.ZERO;
        }
    }

    BasicBlockValue(int tag, Value[] vals) {
        super(tag, vals.length);
        int sz = vals.length;
        this.values = vals;
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public Value get0() {
        return this.values[0];
    }

    @Override
    public Value get1() {
        return this.values[1];
    }

    @Override
    public Value get2() {
        return this.values[2];
    }

    @Override
    public Value get3() {
        return this.values[3];
    }

    @Override
    public Value get4() {
        return this.values[4];
    }

    @Override
    public Value get5() {
        return this.values[5];
    }

    @Override
    public Value get6() {
        return this.values[6];
    }

    @Override
    public Value get7() {
        return this.values[7];
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[(int)idx] = x;
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[idx] = x;
    }

    @Override
    public void set0(Value x) {
        assert (x != null) : "null x";
        this.values[0] = x;
    }

    @Override
    public void set1(Value x) {
        assert (x != null) : "null x";
        this.values[1] = x;
    }

    @Override
    public void set2(Value x) {
        assert (x != null) : "null x";
        this.values[2] = x;
    }

    @Override
    public void set3(Value x) {
        assert (x != null) : "null x";
        this.values[3] = x;
    }

    @Override
    public void set4(Value x) {
        assert (x != null) : "null x";
        this.values[4] = x;
    }

    @Override
    public void set5(Value x) {
        assert (x != null) : "null x";
        this.values[5] = x;
    }

    @Override
    public void set6(Value x) {
        assert (x != null) : "null x";
        this.values[6] = x;
    }

    @Override
    public void set7(Value x) {
        assert (x != null) : "null x";
        this.values[7] = x;
    }

    @Override
    public long sizeValues() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)sz;
        this.values = Arrays.copyOf(this.values, s);
        this.sizeTagged = s << 1 | 1;
        this.sizeMinusOneTagged = s - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeValues());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.get(i);
        }
    }

    @Override
    public BasicBlockValue duplicate() {
        int len = this.values.length;
        BasicBlockValue res = new BasicBlockValue(this.getTag(), len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        System.arraycopy(this.values, 0, dest, 0, this.values.length);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i].asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i].getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        int tag = this.getTag();
        switch (l) {
            case 0: {
                return new BasicBlockValue0(tag);
            }
            case 1: {
                return new BasicBlockValue1(tag, this.values[o + 0]);
            }
            case 2: {
                return new BasicBlockValue2(tag, this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new BasicBlockValue3(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new BasicBlockValue4(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new BasicBlockValue5(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new BasicBlockValue6(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new BasicBlockValue7(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new BasicBlockValue8(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        Value[] v = new Value[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new BasicBlockValue(tag, v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof BasicBlockValue) {
            BasicBlockValue that = (BasicBlockValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += this.values[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicBlockValue) {
            BasicBlockValue that = (BasicBlockValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

