/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Int64Value
extends AbstractCustomValue {
    private static final long SIZE = Value.wosize(8L);
    private long int64;

    Int64Value(long v) {
        super(PredefinedCustomOperations.INT_64_OPS, SIZE);
        this.int64 = v;
    }

    @Override
    public long asInt64() {
        return this.int64;
    }

    @Override
    public void setInt64(long v) {
        this.int64 = v;
    }

    @Override
    public void copy(BlockValue src) {
        this.int64 = src.asInt64();
    }

    @Override
    public Int64Value duplicate() {
        return new Int64Value(this.int64);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        return (int)this.int64;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Int64Value) {
            Int64Value that = (Int64Value)obj;
            return this.int64 == that.int64;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Int64Value(");
        sb.append(this.int64);
        sb.append(")");
        return sb.toString();
    }
}

