/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.DatagramChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/socket.c")
public final class Socket {
    private static final int SOCKET_STREAM = 0;
    private static final int SOCKET_DATAGRAM = 1;

    private Socket() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does not support [PF_UNIX] domain. Does only support", "[SOCK_STREAM], and [SOCK_DGRAM]. Protocol is ignored."}, parameterTypes={"Unix.socket_domain", "Unix.socket_type", "int"}, returnType="Unix.file_descr")
    public static Value unix_socket(Value domain, Value type, Value proto) throws Fail.Exception, FalseExit {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (domain == Value.ZERO) {
            Unix.fail("socket", "unsupported socket domain");
            return Value.UNIT;
        }
        try {
            switch (type.asCastedInt()) {
                case 0: {
                    return Value.createLong(ctxt.getFilesState().addChannel(new Channel()));
                }
                case 1: {
                    return Value.createLong(ctxt.getFilesState().addChannel(new Channel(DatagramChannel.open())));
                }
            }
            Unix.fail("socket", "unsupported socket type");
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("socket", ioe);
            return Value.UNIT;
        }
    }
}

