/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.invoke.MethodHandle;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.AbstractValue;
import org.ocamljava.runtime.values.BasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.CustomValue;
import org.ocamljava.runtime.values.DoubleArrayValue;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.DoubleValue;
import org.ocamljava.runtime.values.InfixBlockValue;
import org.ocamljava.runtime.values.Int32Value;
import org.ocamljava.runtime.values.Int64Value;
import org.ocamljava.runtime.values.LargeBasicBlockValue;
import org.ocamljava.runtime.values.LargeDoubleArrayValue;
import org.ocamljava.runtime.values.LargeLongBlockValue;
import org.ocamljava.runtime.values.LargeStringValue;
import org.ocamljava.runtime.values.LargeWeakBlockValue;
import org.ocamljava.runtime.values.LongBlockValue;
import org.ocamljava.runtime.values.LongBlockValue0;
import org.ocamljava.runtime.values.LongBlockValue1;
import org.ocamljava.runtime.values.LongBlockValue2;
import org.ocamljava.runtime.values.LongBlockValue3;
import org.ocamljava.runtime.values.LongBlockValue4;
import org.ocamljava.runtime.values.LongBlockValue5;
import org.ocamljava.runtime.values.LongBlockValue6;
import org.ocamljava.runtime.values.LongBlockValue7;
import org.ocamljava.runtime.values.LongBlockValue8;
import org.ocamljava.runtime.values.LongValue;
import org.ocamljava.runtime.values.MethodHandleValue;
import org.ocamljava.runtime.values.NativeIntValue;
import org.ocamljava.runtime.values.OffsetValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.StringValue;
import org.ocamljava.runtime.values.WeakBlockValue;

public abstract class Value {
    public static final int LONG_SIZE = 8;
    public static final Value UNIT;
    public static final Value FALSE;
    public static final Value TRUE;
    public static final Value EMPTY_LIST;
    public static final Value ZERO;
    public static final Value ONE;
    public static final Value TWO;
    public static final Value THREE;
    public static final Value FOUR;
    public static final Value FIVE;
    public static final Value SIX;
    public static final Value SEVEN;
    public static final Value EIGHT;
    public static final Value MINUS_ONE;
    public static final Value MINUS_TWO;
    public static final long MAX_LONG = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN_LONG = -4611686018427387904L;
    public static final long MIN_CACHED_VALUE = -128L;
    public static final long MAX_CACHED_VALUE = 255L;
    public static final long MIN_RAW_CACHED_VALUE = -255L;
    public static final long MAX_RAW_CACHED_VALUE = 511L;
    public static final int MAX_HASH_ELEMENTS = 32;
    private static final long UNIT_AS_LONG = 0L;
    private static final long FALSE_AS_LONG = 0L;
    private static final long TRUE_AS_LONG = 1L;
    private static final long EMPTY_LIST_AS_LONG = 0L;
    private static final LongValue[] CACHED_VALUES;
    private static final LongValue[] RAW_CACHED_VALUES;
    public static long MAX_INTEGER;
    public static long MIN_INTEGER;
    private static final long INTEGER_CARDINALITY;

    public static Value createLong(long v) {
        if (v >= -128L && v <= 255L) {
            return CACHED_VALUES[(int)(v - -128L)];
        }
        long w = v << 1;
        return new LongValue(w >> 1, w | 1L);
    }

    public static Value createCodeOffset(long ofs) {
        return new OffsetValue(ofs << 1 >> 1);
    }

    public static Value createFromRawValue(long value) {
        if ((value & 1L) != 0L) {
            return Value.createLong(value >> 1);
        }
        return new OffsetValue(value >> 1);
    }

    public static Value createFromRawLong(long value) {
        if (value >= -255L && value <= 511L) {
            LongValue res = RAW_CACHED_VALUES[(int)(value - -255L)];
            assert (res != null) : "null res";
            return res;
        }
        assert ((value & 1L) != 0L) : "invalid value";
        return new LongValue(value >> 1, value);
    }

    public static Value createString(long len) {
        if (len < MAX_INTEGER) {
            return new StringValue((int)len);
        }
        return new LargeStringValue(len);
    }

    public static Value createString(long len, String s) {
        if (len < MAX_INTEGER) {
            return new StringValue((long)((int)len), s);
        }
        return new LargeStringValue(len, s);
    }

    public static Value createString(long len, byte[] s) {
        if (len < MAX_INTEGER) {
            return new StringValue((long)((int)len), s);
        }
        return new LargeStringValue(len, s);
    }

    public static Value createString(byte[] s) {
        return new StringValue(s);
    }

    public static Value createString(String s) {
        return new StringValue(s);
    }

    public static Value createInt(long x) {
        return Value.createLong(x);
    }

    public static Value createInt32(int x) {
        return new Int32Value(x);
    }

    public static Value createNativeInt(long x) {
        return new NativeIntValue(x);
    }

    public static Value createInt64(long x) {
        return new Int64Value(x);
    }

    public static Value createChannel(Channel ch) {
        assert (ch != null) : "null ch";
        return Value.createCustom(PredefinedCustomOperations.CHANNEL_OPS, 65580L, ch);
    }

    public static Value createInstance(Object obj) {
        return Value.createCustom(PredefinedCustomOperations.JAVA_OPS, 8L, obj);
    }

    public static Value createStringArray(String[] s) {
        assert (s != null) : "null s";
        int len = s.length;
        Value res = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            res.set(i, Value.createString(s[i]));
        }
        return res;
    }

    public static Value createCustom(CustomOperations ops, long sz, Object o) {
        CustomValue res = new CustomValue(ops, sz, o);
        if (ops.isFinalized()) {
            OCamlJavaThread.getCodeRunner().getContext().getFinalizersState().addFinalizer(res);
        }
        return res;
    }

    public static Value createCustom(CustomOperations ops, long sz) {
        return Value.createCustom(ops, sz, null);
    }

    public static Value createAbstract(long sz, Object o) {
        return new AbstractValue(sz, o);
    }

    public static Value createBlock(int tag, long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new BasicBlockValue0(tag);
                }
                case 1: {
                    return new BasicBlockValue1(tag, ZERO);
                }
                case 2: {
                    return new BasicBlockValue2(tag, ZERO, ZERO);
                }
                case 3: {
                    return new BasicBlockValue3(tag, ZERO, ZERO, ZERO);
                }
                case 4: {
                    return new BasicBlockValue4(tag, ZERO, ZERO, ZERO, ZERO);
                }
                case 5: {
                    return new BasicBlockValue5(tag, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 6: {
                    return new BasicBlockValue6(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 7: {
                    return new BasicBlockValue7(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 8: {
                    return new BasicBlockValue8(tag, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
            }
            return new BasicBlockValue(tag, s);
        }
        return new LargeBasicBlockValue(tag, sz);
    }

    public static Value createBlock(int tag) {
        return new BasicBlockValue0(tag);
    }

    public static Value createBlock(int tag, Value v0) {
        return new BasicBlockValue1(tag, v0);
    }

    public static Value createBlock(int tag, Value v0, Value v1) {
        return new BasicBlockValue2(tag, v0, v1);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2) {
        return new BasicBlockValue3(tag, v0, v1, v2);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3) {
        return new BasicBlockValue4(tag, v0, v1, v2, v3);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4) {
        return new BasicBlockValue5(tag, v0, v1, v2, v3, v4);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5) {
        return new BasicBlockValue6(tag, v0, v1, v2, v3, v4, v5);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5, Value v6) {
        return new BasicBlockValue7(tag, v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createBlock(int tag, Value v0, Value v1, Value v2, Value v3, Value v4, Value v5, Value v6, Value v7) {
        return new BasicBlockValue8(tag, v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createBlock(int tag, Value[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new BasicBlockValue0(tag);
            }
            case 1: {
                return new BasicBlockValue1(tag, values[0]);
            }
            case 2: {
                return new BasicBlockValue2(tag, values[0], values[1]);
            }
            case 3: {
                return new BasicBlockValue3(tag, values[0], values[1], values[2]);
            }
            case 4: {
                return new BasicBlockValue4(tag, values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new BasicBlockValue5(tag, values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new BasicBlockValue6(tag, values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new BasicBlockValue7(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new BasicBlockValue8(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new BasicBlockValue(tag, values);
    }

    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return ZERO;
    }

    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return ZERO;
    }

    public Value get0() {
        return this.get(0L);
    }

    public Value get1() {
        return this.get(1L);
    }

    public Value get2() {
        return this.get(2L);
    }

    public Value get3() {
        return this.get(3L);
    }

    public Value get4() {
        return this.get(4L);
    }

    public Value get5() {
        return this.get(5L);
    }

    public Value get6() {
        return this.get(6L);
    }

    public Value get7() {
        return this.get(7L);
    }

    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    public void set0(Value x) {
        this.set(0L, x);
    }

    public void set1(Value x) {
        this.set(1L, x);
    }

    public void set2(Value x) {
        this.set(2L, x);
    }

    public void set3(Value x) {
        this.set(3L, x);
    }

    public void set4(Value x) {
        this.set(4L, x);
    }

    public void set5(Value x) {
        this.set(5L, x);
    }

    public void set6(Value x) {
        this.set(6L, x);
    }

    public void set7(Value x) {
        this.set(7L, x);
    }

    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    public static Value createDoubleArray(long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new DoubleArrayValue0();
                }
                case 1: {
                    return new DoubleArrayValue1();
                }
                case 2: {
                    return new DoubleArrayValue2();
                }
                case 3: {
                    return new DoubleArrayValue3();
                }
                case 4: {
                    return new DoubleArrayValue4();
                }
                case 5: {
                    return new DoubleArrayValue5();
                }
                case 6: {
                    return new DoubleArrayValue6();
                }
                case 7: {
                    return new DoubleArrayValue7();
                }
                case 8: {
                    return new DoubleArrayValue8();
                }
            }
            return new DoubleArrayValue(s);
        }
        return new LargeDoubleArrayValue(sz);
    }

    public static Value createDoubleArray() {
        return new DoubleArrayValue0();
    }

    public static Value createDoubleArray(double v0) {
        return new DoubleArrayValue1(v0);
    }

    public static Value createDoubleArray(double v0, double v1) {
        return new DoubleArrayValue2(v0, v1);
    }

    public static Value createDoubleArray(double v0, double v1, double v2) {
        return new DoubleArrayValue3(v0, v1, v2);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3) {
        return new DoubleArrayValue4(v0, v1, v2, v3);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4) {
        return new DoubleArrayValue5(v0, v1, v2, v3, v4);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5) {
        return new DoubleArrayValue6(v0, v1, v2, v3, v4, v5);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5, double v6) {
        return new DoubleArrayValue7(v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createDoubleArray(double v0, double v1, double v2, double v3, double v4, double v5, double v6, double v7) {
        return new DoubleArrayValue8(v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createDoubleArray(double[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(values[0]);
            }
            case 2: {
                return new DoubleArrayValue2(values[0], values[1]);
            }
            case 3: {
                return new DoubleArrayValue3(values[0], values[1], values[2]);
            }
            case 4: {
                return new DoubleArrayValue4(values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new DoubleArrayValue5(values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new DoubleArrayValue6(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new DoubleArrayValue7(values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new DoubleArrayValue8(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new DoubleArrayValue(values);
    }

    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    public double getDouble0() {
        return this.getDouble(0L);
    }

    public double getDouble1() {
        return this.getDouble(1L);
    }

    public double getDouble2() {
        return this.getDouble(2L);
    }

    public double getDouble3() {
        return this.getDouble(3L);
    }

    public double getDouble4() {
        return this.getDouble(4L);
    }

    public double getDouble5() {
        return this.getDouble(5L);
    }

    public double getDouble6() {
        return this.getDouble(6L);
    }

    public double getDouble7() {
        return this.getDouble(7L);
    }

    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    public void setDouble0(double x) {
        this.setDouble(0L, x);
    }

    public void setDouble1(double x) {
        this.setDouble(1L, x);
    }

    public void setDouble2(double x) {
        this.setDouble(2L, x);
    }

    public void setDouble3(double x) {
        this.setDouble(3L, x);
    }

    public void setDouble4(double x) {
        this.setDouble(4L, x);
    }

    public void setDouble5(double x) {
        this.setDouble(5L, x);
    }

    public void setDouble6(double x) {
        this.setDouble(6L, x);
    }

    public void setDouble7(double x) {
        this.setDouble(7L, x);
    }

    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.get(idx).asDouble();
    }

    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.get(idx).asDouble();
    }

    public double getGenericDouble0() {
        return this.get0().asDouble();
    }

    public double getGenericDouble1() {
        return this.get1().asDouble();
    }

    public double getGenericDouble2() {
        return this.get2().asDouble();
    }

    public double getGenericDouble3() {
        return this.get3().asDouble();
    }

    public double getGenericDouble4() {
        return this.get4().asDouble();
    }

    public double getGenericDouble5() {
        return this.get5().asDouble();
    }

    public double getGenericDouble6() {
        return this.get6().asDouble();
    }

    public double getGenericDouble7() {
        return this.get7().asDouble();
    }

    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.set(idx, Value.createDouble(x));
    }

    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.set(idx, Value.createDouble(x));
    }

    public void setGenericDouble0(double x) {
        this.set0(Value.createDouble(x));
    }

    public void setGenericDouble1(double x) {
        this.set1(Value.createDouble(x));
    }

    public void setGenericDouble2(double x) {
        this.set2(Value.createDouble(x));
    }

    public void setGenericDouble3(double x) {
        this.set3(Value.createDouble(x));
    }

    public void setGenericDouble4(double x) {
        this.set4(Value.createDouble(x));
    }

    public void setGenericDouble5(double x) {
        this.set5(Value.createDouble(x));
    }

    public void setGenericDouble6(double x) {
        this.set6(Value.createDouble(x));
    }

    public void setGenericDouble7(double x) {
        this.set7(Value.createDouble(x));
    }

    public static Value createLongBlockFromSize(int tag, long sz) {
        if (sz < MAX_INTEGER) {
            int s = (int)sz;
            switch (s) {
                case 0: {
                    return new LongBlockValue0(tag);
                }
                case 1: {
                    return new LongBlockValue1(tag, 0L);
                }
                case 2: {
                    return new LongBlockValue2(tag, 0L, 0L);
                }
                case 3: {
                    return new LongBlockValue3(tag, 0L, 0L, 0L);
                }
                case 4: {
                    return new LongBlockValue4(tag, 0L, 0L, 0L, 0L);
                }
                case 5: {
                    return new LongBlockValue5(tag, 0L, 0L, 0L, 0L, 0L);
                }
                case 6: {
                    return new LongBlockValue6(tag, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 7: {
                    return new LongBlockValue7(tag, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 8: {
                    return new LongBlockValue8(tag, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
            }
            return new LongBlockValue(tag, s);
        }
        return new LargeLongBlockValue(tag, sz);
    }

    public static Value createLongBlock(int tag) {
        return new LongBlockValue0(tag);
    }

    public static Value createLongBlock(int tag, long v0) {
        return new LongBlockValue1(tag, v0);
    }

    public static Value createLongBlock(int tag, long v0, long v1) {
        return new LongBlockValue2(tag, v0, v1);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2) {
        return new LongBlockValue3(tag, v0, v1, v2);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3) {
        return new LongBlockValue4(tag, v0, v1, v2, v3);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4) {
        return new LongBlockValue5(tag, v0, v1, v2, v3, v4);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5) {
        return new LongBlockValue6(tag, v0, v1, v2, v3, v4, v5);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5, long v6) {
        return new LongBlockValue7(tag, v0, v1, v2, v3, v4, v5, v6);
    }

    public static Value createLongBlock(int tag, long v0, long v1, long v2, long v3, long v4, long v5, long v6, long v7) {
        return new LongBlockValue8(tag, v0, v1, v2, v3, v4, v5, v6, v7);
    }

    public static Value createLongBlock(int tag, long[] values) {
        int len = values.length;
        switch (len) {
            case 0: {
                return new LongBlockValue0(tag);
            }
            case 1: {
                return new LongBlockValue1(tag, values[0]);
            }
            case 2: {
                return new LongBlockValue2(tag, values[0], values[1]);
            }
            case 3: {
                return new LongBlockValue3(tag, values[0], values[1], values[2]);
            }
            case 4: {
                return new LongBlockValue4(tag, values[0], values[1], values[2], values[3]);
            }
            case 5: {
                return new LongBlockValue5(tag, values[0], values[1], values[2], values[3], values[4]);
            }
            case 6: {
                return new LongBlockValue6(tag, values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            case 7: {
                return new LongBlockValue7(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6]);
            }
            case 8: {
                return new LongBlockValue8(tag, values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]);
            }
        }
        return new LongBlockValue(tag, values);
    }

    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    public long getRawLong0() {
        return this.getRawLong(0L);
    }

    public long getRawLong1() {
        return this.getRawLong(1L);
    }

    public long getRawLong2() {
        return this.getRawLong(2L);
    }

    public long getRawLong3() {
        return this.getRawLong(3L);
    }

    public long getRawLong4() {
        return this.getRawLong(4L);
    }

    public long getRawLong5() {
        return this.getRawLong(5L);
    }

    public long getRawLong6() {
        return this.getRawLong(6L);
    }

    public long getRawLong7() {
        return this.getRawLong(7L);
    }

    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    public void setRawLong0(long x) {
        this.setRawLong(0L, x);
    }

    public void setRawLong1(long x) {
        this.setRawLong(1L, x);
    }

    public void setRawLong2(long x) {
        this.setRawLong(2L, x);
    }

    public void setRawLong3(long x) {
        this.setRawLong(3L, x);
    }

    public void setRawLong4(long x) {
        this.setRawLong(4L, x);
    }

    public void setRawLong5(long x) {
        this.setRawLong(5L, x);
    }

    public void setRawLong6(long x) {
        this.setRawLong(6L, x);
    }

    public void setRawLong7(long x) {
        this.setRawLong(7L, x);
    }

    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    public static Value createDouble(double d) {
        return new DoubleValue(d);
    }

    public static Value createClosure(long sz) {
        Value res = Value.createBlock(247, sz);
        if (sz > 0L) {
            res.set(0L, Value.createCodeOffset(0L));
        }
        return res;
    }

    public static Value createClosure(long sz, long code) {
        Value res = Value.createBlock(247, sz);
        if (sz > 0L) {
            res.set(0L, Value.createCodeOffset(code));
        }
        return res;
    }

    public static Value createClosure(MethodHandle mh) {
        Value res = Value.createBlock(247, ZERO, ONE);
        res.set0(new MethodHandleValue(mh, res));
        return res;
    }

    public static Value createClosure(MethodHandle mh, int arity) {
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        Value res = Value.createBlock(247, code, Value.createLong(arity), ZERO);
        res.set2(new MethodHandleValue(mh, res));
        return res;
    }

    public static Value createInfix(int tag) {
        return new InfixBlockValue(tag);
    }

    public static Value createAtom(int tag) {
        return new BasicBlockValue0(tag);
    }

    public static Value createWeakBlock(long sz) {
        if (sz < MAX_INTEGER) {
            return new WeakBlockValue((int)sz);
        }
        return new LargeWeakBlockValue(sz);
    }

    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    public int getTag() {
        assert (false) : "getTag() called on an instance of " + this.getClass();
        return 0;
    }

    public long getHeader() {
        assert (false) : "getHeader() called on an instance of " + this.getClass();
        return 0L;
    }

    public long getWoSize() {
        assert (false) : "getWoSize() called on an instance of " + this.getClass();
        return 0L;
    }

    public long getMagicNumber() {
        assert (false) : "getMagicNumber() called on an instance of " + this.getClass();
        return 0L;
    }

    public void setTag(int t) {
        assert (false) : "setTag(int) called on an instance of " + this.getClass();
    }

    public abstract boolean isLong();

    public abstract boolean isCodeOffset();

    public abstract boolean isMethodHandle();

    public abstract boolean isBlock();

    public abstract boolean isDoubleArray();

    public abstract boolean isLongBlock();

    public abstract boolean isDouble();

    public abstract long getRawValue();

    public abstract long asLong();

    public final int asCastedInt() {
        return (int)this.asLong();
    }

    public final int asBoundedInt() throws Fatal.Exception {
        long l = this.asLong();
        if (l >= MIN_INTEGER && l <= MAX_INTEGER) {
            return (int)l;
        }
        Fatal.raise64bitElement();
        return 0;
    }

    public abstract long asCodeOffset();

    public int getApplicationKind() {
        long ofs = this.asCodeOffset();
        if (ofs == -1L) {
            return 0;
        }
        if (ofs >= 0L) {
            return 1;
        }
        return 2;
    }

    public BlockValue asBlock() {
        assert (false) : "asBlock() called on an instance of " + this.getClass();
        return null;
    }

    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    public long sizeBytesTagged() {
        return this.sizeBytes() << 1 | 1L;
    }

    public long sizeBytesMinusOneTagged() {
        return this.sizeBytes() - 1L << 1 | 1L;
    }

    public Value sizeBytesWrapped() {
        return Value.createLong(this.sizeBytes());
    }

    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    public void setInt64(long v) {
        assert (false) : "setInt64(long) called on an instance of " + this.getClass();
    }

    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    public final Value setClosure(MethodHandle mh) {
        assert (mh != null) : "null mh";
        this.set0(new MethodHandleValue(mh, this));
        this.set1(ONE);
        return this;
    }

    public final Value setClosure(MethodHandle mh, int arity) {
        assert (mh != null) : "null mh";
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        this.set0(code);
        this.set1(Value.createLong(arity));
        this.set2(new MethodHandleValue(mh, this));
        return this;
    }

    public final Value setInfix(MethodHandle mh, long idx) {
        assert (mh != null) : "null mh";
        Value infix = Value.createInfix((int)(idx + 1L));
        infix.setParent((BlockValue)this);
        infix.set0(new MethodHandleValue(mh, infix));
        this.set(idx, Value.createFromRawValue(infix.getTag()));
        this.set(idx + 1L, infix);
        this.set(idx + 2L, ONE);
        return this;
    }

    public final Value setInfix(MethodHandle mh, long idx, int arity) {
        assert (mh != null) : "null mh";
        Value code = Value.createCodeOffset(arity < 0 ? -1L : (long)(-arity - 1));
        Value infix = Value.createInfix((int)(idx + 1L));
        infix.setParent((BlockValue)this);
        infix.set0(code);
        this.set(idx, Value.createFromRawValue(infix.getTag()));
        this.set(idx + 1L, infix);
        this.set(idx + 2L, Value.createLong(arity));
        this.set(idx + 3L, (Value)new MethodHandleValue(mh, infix));
        return this;
    }

    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        this.set(idx, x);
    }

    public Value offset(long ofs) {
        assert (false) : "offset(int) called on an instance of " + this.getClass();
        return null;
    }

    public long arrayLength() {
        return this.sizeValues();
    }

    public long arrayLengthTagged() {
        return this.sizeValues() << 1 | 1L;
    }

    public long arrayLengthMinusOneTagged() {
        return this.sizeValues() - 1L << 1 | 1L;
    }

    public Value arrayLengthWrapped() {
        return Value.createLong(this.sizeValues());
    }

    public abstract int switchTag();

    public abstract Value duplicate();

    public abstract void copyValuesIntoArray(Value[] var1);

    public abstract void copyValuesIntoArray(Value[] var1, int var2);

    public abstract void copyDoublesIntoArray(double[] var1, int var2);

    public abstract void copyRawLongsIntoArray(long[] var1, int var2);

    public abstract Value subArray(long var1, long var3);

    public abstract void blitArray(long var1, Value var3, long var4, long var6);

    private static int kind(Value v) {
        if (v.isBlock()) {
            return 0;
        }
        if (v.isLong()) {
            return 1;
        }
        return 2;
    }

    private static int kindTimes4(Value v) {
        if (v.isBlock()) {
            return 0;
        }
        if (v.isLong()) {
            return 4;
        }
        return 8;
    }

    public static int compare(Value v1, Value v2) {
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        switch (Value.kindTimes4(v1) | Value.kind(v2)) {
            case 0: {
                long mn1 = v1.getMagicNumber();
                long mn2 = v2.getMagicNumber();
                return mn1 == mn2 ? 0 : (mn1 < mn2 ? 1 : -1);
            }
            case 1: {
                return -1;
            }
            case 2: {
                return -1;
            }
            case 3: {
                assert (false) : "should not happen";
                return -1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                long l1 = v1.asLong();
                long l2 = v2.asLong();
                return l1 == l2 ? 0 : (l1 < l2 ? -1 : 1);
            }
            case 6: {
                return -1;
            }
            case 7: {
                assert (false) : "should not happen";
                return -1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                long l1 = v1.asLong();
                long l2 = v2.asLong();
                return l1 == l2 ? 0 : (l1 < l2 ? -1 : 1);
            }
        }
        assert (false) : "should not happen";
        return -1;
    }

    public static int compareUnsigned(Value v1, Value v2) {
        long l2;
        int k2;
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        int k1 = Value.kind(v1);
        if (k1 < (k2 = Value.kind(v2))) {
            return -1;
        }
        if (k1 > k2) {
            return 1;
        }
        if (k1 == 0) {
            long mn2;
            long mn1 = v1.getMagicNumber();
            return mn1 == (mn2 = v2.getMagicNumber()) ? 0 : (mn1 < mn2 ? 1 : -1);
        }
        if (k1 == 1) {
            long l22;
            long hi2;
            long l1 = v1.asLong();
            long hi1 = l1 >> 32 & 0xFFFFFFFFL;
            if (hi1 < (hi2 = (l22 = v2.asLong()) >> 32 & 0xFFFFFFFFL)) {
                return -1;
            }
            if (hi1 > hi2) {
                return 1;
            }
            long lo1 = l1 & 0xFFFFFFFFL;
            long lo2 = l22 & 0xFFFFFFFFL;
            return lo1 == lo2 ? 0 : (lo1 < lo2 ? -1 : 1);
        }
        long l1 = v1.asLong();
        return l1 == (l2 = v2.asLong()) ? 0 : (l1 < l2 ? -1 : 1);
    }

    public static int compareUsingMagicNumbers(Value v1, Value v2) {
        long mn2;
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        assert (v1.isBlock()) : "v1 should be a block";
        assert (v2.isBlock()) : "v2 should be a block";
        long mn1 = v1.getMagicNumber();
        return mn1 == (mn2 = v2.getMagicNumber()) ? 0 : (mn1 < mn2 ? 1 : -1);
    }

    static long wosize(long words) {
        assert (words >= 0L) : "bytes should be >= 0";
        long valueSize = 8L;
        return 1L + (words + 8L - 1L) / 8L;
    }

    static {
        MAX_INTEGER = Integer.MAX_VALUE;
        MIN_INTEGER = Integer.MIN_VALUE;
        INTEGER_CARDINALITY = MAX_INTEGER - MIN_INTEGER + 1L;
        CACHED_VALUES = new LongValue[384];
        RAW_CACHED_VALUES = new LongValue[767];
        int r = -255;
        for (int i = -128; i <= 255; ++i) {
            LongValue lv;
            Value.CACHED_VALUES[i - -128] = lv = new LongValue(i, r);
            Value.RAW_CACHED_VALUES[r - -255] = lv;
            r += 2;
        }
        UNIT = Value.createLong(0L);
        FALSE = Value.createLong(0L);
        TRUE = Value.createLong(1L);
        EMPTY_LIST = Value.createLong(0L);
        ZERO = Value.createLong(0L);
        ONE = Value.createLong(1L);
        TWO = Value.createLong(2L);
        THREE = Value.createLong(3L);
        FOUR = Value.createLong(4L);
        FIVE = Value.createLong(5L);
        SIX = Value.createLong(6L);
        SEVEN = Value.createLong(7L);
        EIGHT = Value.createLong(8L);
        MINUS_ONE = Value.createLong(-1L);
        MINUS_TWO = Value.createLong(-2L);
    }
}

