/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/select.c")
public final class Select {
    private Select() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does wait for given time if all descriptor lists are empty (as used by threads to emulate delay)."}, parameterTypes={"Unix.file_descr list", "Unix.file_descr list", "Unix.file_descr list", "float"}, returnType="Unix.file_descr list * Unix.file_descr list * Unix.file_descr list")
    public static Value unix_select(Value readfds, Value writefds, Value exceptfds, Value timeout) throws FalseExit, Fail.Exception {
        double t;
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        if (readfds == Value.EMPTY_LIST && writefds == Value.EMPTY_LIST && exceptfds == Value.EMPTY_LIST && (t = timeout.asDouble()) > 0.0) {
            ctxt.enterBlockingSection();
            try {
                Thread.sleep((long)(t * 1000.0));
            }
            catch (InterruptedException ie) {
                FalseExit fe = FalseExit.createFromContext(ctxt);
                fe.fillInStackTrace();
                throw fe;
            }
            ctxt.leaveBlockingSection();
        }
        return Value.createBlock(0, readfds, writefds, exceptfds);
    }
}

