/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.primitives.otherlibs.graph.Events;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

public final class GraphSlot {
    public static final Object SLOT = new Object();
    static final Object SLOT_TITLE = new Object();
    static final String DEFAULT_TITLE = "OCaml graphics";
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int EVENT_QUEUE_SIZE = 256;
    private final GraphCanvas canvas;
    private final Frame frame;
    private boolean displayMode;
    private boolean rememberMode;
    private Font font;
    private final Color background;
    private Color color;
    private BufferedImage buffer;
    private BufferedImage backingStore;
    private int x;
    private int y;
    private int lineWidth;
    private boolean mouseButton;
    private final List<Event> eventQueue;

    public GraphSlot(CommonParameters params, String id, String geom) throws HeadlessException {
        int sy;
        int sx;
        assert (params != null) : "null params";
        assert (id != null) : "null id";
        assert (geom != null) : "null geom";
        this.displayMode = true;
        this.rememberMode = true;
        this.font = new Font(DEFAULT_FONT_NAME, 0, 12);
        this.background = Color.WHITE;
        this.color = Color.BLACK;
        this.x = 0;
        this.y = 0;
        this.lineWidth = 1;
        this.mouseButton = false;
        this.eventQueue = new LinkedList<Event>();
        if (geom.matches("[0-9]+x[0-9]+")) {
            String[] xy = geom.split("x");
            sx = Integer.parseInt(xy[0]);
            sy = Integer.parseInt(xy[1]);
        } else {
            sx = 640;
            sy = 480;
        }
        this.buffer = new BufferedImage(sx, sy, 2);
        Graphics2D g = this.buffer.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, sx, sy);
        g.dispose();
        this.backingStore = new BufferedImage(sx, sy, 2);
        Graphics2D g2 = this.backingStore.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, sx, sy);
        g2.dispose();
        this.canvas = new GraphCanvas(sx, sy);
        this.canvas.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                GraphSlot graphSlot = GraphSlot.this;
                synchronized (graphSlot) {
                    e.consume();
                    GraphSlot.this.mouseButton = true;
                    GraphSlot.this.addEvent(new Event(0, e.getX(), e.getY(), true, null));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                GraphSlot graphSlot = GraphSlot.this;
                synchronized (graphSlot) {
                    e.consume();
                    GraphSlot.this.mouseButton = false;
                    GraphSlot.this.addEvent(new Event(1, e.getX(), e.getY(), false, null));
                }
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseMoved(MouseEvent e) {
                GraphSlot graphSlot = GraphSlot.this;
                synchronized (graphSlot) {
                    e.consume();
                    GraphSlot.this.addEvent(new Event(3, e.getX(), e.getY(), e.getButton() != 0, null));
                }
            }
        });
        this.canvas.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                GraphSlot graphSlot = GraphSlot.this;
                synchronized (graphSlot) {
                    e.consume();
                    GraphSlot.this.addEvent(new Event(2, 0, 0, false, IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(e.getKeyChar()))));
                }
            }
        });
        if (params.isBareCanvas()) {
            this.frame = null;
        } else {
            if (params.isFrameAWT()) {
                this.frame = new Frame(id);
            } else {
                JFrame jf = new JFrame(id);
                jf.setDefaultCloseOperation(3);
                this.frame = jf;
            }
            this.frame.setLayout(new BorderLayout());
            this.frame.add((Component)this.canvas, "Center");
            this.frame.pack();
            this.frame.setVisible(true);
            this.canvas.requestFocus();
        }
    }

    static void fail(String fmt, String arg) throws Fail.Exception {
        assert (fmt != null) : "null fmt";
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        Value exn = ctxt.getCodeState().getCallback("Graphics.Graphic_failure");
        if (exn == null) {
            Fail.invalidArgument("Exception Graphics.graphic_failure not initialized, must link graphics.cma");
        } else {
            StringBuilder sb = new StringBuilder();
            Formatter f = new Formatter(sb);
            f.format(fmt, arg);
            Fail.raiseWithString(exn, sb.toString());
        }
    }

    static GraphSlot checkGraph() throws Fail.Exception {
        Context ctxt = OCamlJavaThread.getCodeRunner().getContext();
        GraphSlot res = (GraphSlot)ctxt.getCodeState().getSlot(SLOT);
        if (res != null) {
            return res;
        }
        GraphSlot.fail("Graphic screen not opened", "");
        return null;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    void setDisplayMode(boolean b) {
        this.displayMode = b;
    }

    void setRememberMode(boolean b) {
        this.rememberMode = b;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        assert (f != null) : "null f";
        this.font = f;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        assert (c != null) : "null c";
        this.color = c;
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public BufferedImage getBackingStore() {
        return this.backingStore;
    }

    Graphics2D createWindowGraphics() {
        if (this.displayMode) {
            Graphics2D g = this.buffer.createGraphics();
            g.setFont(this.font);
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.lineWidth));
            return g;
        }
        return null;
    }

    Graphics2D createBackingStoreGraphics() {
        if (this.rememberMode) {
            Graphics2D g = this.backingStore.createGraphics();
            g.setFont(this.font);
            g.setColor(this.color);
            g.setStroke(new BasicStroke(this.lineWidth));
            return g;
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.canvas.width;
    }

    public int getHeight() {
        return this.canvas.height;
    }

    int convertY(int y) {
        return this.buffer.getHeight() - 1 - y;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lw) {
        this.lineWidth = Math.max(1, lw);
    }

    synchronized boolean isMouseButton() {
        return this.mouseButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(Event e) {
        List<Event> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(e);
            while (this.eventQueue.size() > 256) {
                this.eventQueue.remove(0);
            }
            this.eventQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value waitEvent(boolean pressed, boolean released, boolean keyPressed, boolean motion) throws FalseExit, Fail.Exception {
        while (true) {
            List<Event> list = this.eventQueue;
            synchronized (list) {
                Iterator<Event> it = this.eventQueue.iterator();
                while (it.hasNext()) {
                    Event e = it.next();
                    it.remove();
                    int kind = e.getKind();
                    if (!(kind == 0 && pressed || kind == 1 && released || kind == 2 && keyPressed) && (kind != 3 || !motion)) continue;
                    return Events.allocateResult(this, e.getMouseX(), e.getMouseY(), e.isButton(), e.getKey());
                }
                try {
                    this.eventQueue.wait();
                }
                catch (InterruptedException ie) {
                    FalseExit fe = FalseExit.createFromContext(OCamlJavaThread.getCodeRunner().getContext());
                    fe.fillInStackTrace();
                    throw fe;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getKey() {
        List<Event> list = this.eventQueue;
        synchronized (list) {
            for (Event e : this.eventQueue) {
                if (e.getKind() != 2) continue;
                return e.getKey();
            }
        }
        return null;
    }

    void changeSize(int w, int h) {
        if (this.frame != null) {
            this.canvas.changeSize(w, h);
            this.frame.pack();
        }
    }

    void repaint() {
        this.canvas.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    private final class GraphCanvas
    extends Canvas {
        static final long serialVersionUID = -2093019317115730463L;
        private int width;
        private int height;

        private GraphCanvas(int w, int h) {
            this.width = w;
            this.height = h;
        }

        private void changeSize(int w, int h) {
            this.width = w;
            this.height = h;
            this.setSize(w, h);
        }

        @Override
        public Dimension getSize(Dimension rv) {
            rv.width = this.width;
            rv.height = this.height;
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public synchronized void paint(Graphics g) {
            Dimension dim = this.getSize();
            int w = dim.width;
            int h = dim.height;
            if (GraphSlot.this.buffer.getWidth() != w || GraphSlot.this.buffer.getHeight() != h) {
                int dh = h - GraphSlot.this.buffer.getHeight();
                BufferedImage newBuffer = new BufferedImage(w, h, 2);
                Graphics2D g2 = newBuffer.createGraphics();
                g2.setColor(GraphSlot.this.background);
                g2.fillRect(0, 0, w, h);
                g2.drawImage((Image)GraphSlot.this.buffer, 0, dh, null);
                g2.dispose();
                GraphSlot.this.buffer = newBuffer;
                BufferedImage newBackingStore = new BufferedImage(w, h, 2);
                Graphics2D g3 = newBackingStore.createGraphics();
                g3.setColor(GraphSlot.this.background);
                g3.fillRect(0, 0, w, h);
                g3.drawImage((Image)GraphSlot.this.backingStore, 0, dh, null);
                g3.dispose();
                GraphSlot.this.backingStore = newBackingStore;
            }
            super.paint(g);
            g.drawImage(GraphSlot.this.buffer, 0, 0, null);
        }
    }

    private static final class Event {
        private final int kind;
        private final int mouseX;
        private final int mouseY;
        private final boolean button;
        private final Integer key;

        private Event(int k, int x, int y, boolean btn, Integer key) {
            this.kind = k;
            this.mouseX = x;
            this.mouseY = y;
            this.button = btn;
            this.key = key;
        }

        private int getKind() {
            return this.kind;
        }

        private int getMouseX() {
            return this.mouseX;
        }

        private int getMouseY() {
            return this.mouseY;
        }

        private boolean isButton() {
            return this.button;
        }

        private Integer getKey() {
            return this.key;
        }
    }
}

