/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.AnchorParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.FontParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextInterface;
import com.onemoonscientific.swank.canvas.TextParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;
import java.util.Map;
import java.util.TreeMap;

public class ItemText
extends SwkShape
implements TextInterface {
    static BreakIterator wordIterator = BreakIterator.getWordInstance();
    static CanvasParameter[] parameters = new CanvasParameter[]{new TextParameter(), new AnchorParameter(), new FontParameter(), new WidthParameter(), new FillParameter(), new TagsParameter(), new StateParameter(), new TransformerParameter(), new RotateParameter(), new NodeParameter()};
    static Map parameterMap = new TreeMap();
    TextParameters textPar = TextParameters.getDefault();
    int[] ends = null;
    Rectangle2D.Float rf2 = new Rectangle2D.Float();

    ItemText(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.width = 0.0f;
        this.storeCoords = new double[2];
        this.setFont(new Font("Courier", 0, 12));
        this.fill = Color.BLACK;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 2) {
            throw new SwkException("wrong # coordinates: expected 2, got " + coords.length);
        }
        this.setX(coords[0]);
        this.setY(coords[1]);
    }

    public void paintShape(Graphics2D g2) {
        this.shape = this.textPar.paint(g2, this.getCanvas().getFontRenderContext(), this, this.storeCoords[0], this.storeCoords[1]);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "text";
    }

    public double getX() {
        return this.storeCoords[0];
    }

    public void setX(double x) {
        this.storeCoords[0] = x;
    }

    public double getY() {
        return this.storeCoords[1];
    }

    public void setY(double y) {
        this.storeCoords[1] = y;
    }

    public String getText() {
        return this.textPar.getText();
    }

    public void setText(String newValue) {
        this.textPar = TextParameters.setText(this.textPar, newValue);
    }

    public float[] getAnchor() {
        return this.textPar.getAnchor();
    }

    public void setAnchor(float[] newValue) {
        this.textPar = TextParameters.setAnchor(this.textPar, newValue);
    }

    public Font getFont() {
        return this.textPar.getFont();
    }

    public void setFont(Font newValue) {
        this.textPar = TextParameters.setFont(this.textPar, newValue);
    }

    public Color getTextColor() {
        return this.textPar.getTextColor();
    }

    public void setTextColor(Color newValue) {
        this.textPar = TextParameters.setTextColor(this.textPar, newValue);
    }

    public boolean hitShape(double x1, double y1) {
        boolean result = false;
        if (this.shape != null) {
            result = this.shape.contains(x1, y1);
        }
        return result;
    }

    public Rectangle2D getBounds() {
        if (this.shape != null) {
            return this.shape.getBounds2D();
        }
        String text = this.getText();
        if (text == null) {
            return new Rectangle2D.Float((float)this.getX(), (float)this.getY(), 1.0f, 1.0f);
        }
        FontRenderContext fRC = this.canvas.getFontRenderContext();
        if (fRC == null) {
            return new Rectangle2D.Float((float)this.getX(), (float)this.getY(), 1.0f, 1.0f);
        }
        AffineTransform aT = new AffineTransform();
        Font font = this.getFont();
        float width1 = (float)font.getStringBounds(text, fRC).getWidth();
        float height1 = (float)font.getStringBounds(text, fRC).getHeight();
        float width2 = width1 * this.getAnchor()[1];
        float height2 = height1 * this.getAnchor()[0];
        Rectangle2D rf1 = new Rectangle2D.Double((float)(this.getX() - (double)width2), (float)(this.getY() - (double)height1 + (double)height2), width1, height1);
        rf1 = aT.createTransformedShape(rf1).getBounds2D();
        return rf1;
    }

    public void drawHandles(Graphics2D g2) {
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            double xm = (x1 + x2) / 2.0;
            double ym = (y1 + y2) / 2.0;
            double[] xy = new double[]{x2, ym};
            for (int i = 0; i < xy.length; i += 2) {
                this.drawHandle(g2, (int)xy[i], (int)xy[i + 1]);
            }
        }
    }

    public int hitHandles(double testX, double testY) {
        int hitIndex = -1;
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            double xm = (x1 + x2) / 2.0;
            double ym = (y1 + y2) / 2.0;
            double[] xy = new double[]{x2, ym};
            for (int i = 0; i < xy.length; i += 2) {
                if (!this.hitHandle((int)xy[i], (int)xy[i + 1], testX, testY)) continue;
                hitIndex = i / 2;
                break;
            }
        }
        return hitIndex;
    }

    public Cursor getHandleCursor(int handle) {
        Cursor cursor;
        switch (handle) {
            case 0: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            default: {
                cursor = Cursor.getPredefinedCursor(0);
            }
        }
        return cursor;
    }

    static {
        ItemText.initializeParameters(parameters, parameterMap);
    }
}

