/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class ArrowShapeParameter
extends CanvasParameter {
    private static String name = "arrowshape";
    private static String defValue = "8 10 3";
    private double arrowShapeA = 8.0;
    private double arrowShapeB = 10.0;
    private double arrowShapeC = 3.0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-arrowshape".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null || !(swkShape instanceof ItemLine)) {
            throw new TclException(interp, "line shape doesn't exist");
        }
        ItemLine swkLine = (ItemLine)swkShape;
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)swkLine.arrowShapeA));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)swkLine.arrowShapeB));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)swkLine.arrowShapeC));
        return list;
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        TclObject[] arrowShapeList = TclList.getElements((Interp)interp, (TclObject)arg);
        if (arrowShapeList.length != 3) {
            throw new TclException(interp, "bad arrowShape value, must be \"arrowShapeA arrowShapeB arrowShapeC\"");
        }
        this.arrowShapeA = TclDouble.get((Interp)interp, (TclObject)arrowShapeList[0]);
        this.arrowShapeB = TclDouble.get((Interp)interp, (TclObject)arrowShapeList[1]);
        this.arrowShapeC = TclDouble.get((Interp)interp, (TclObject)arrowShapeList[2]);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof ItemLine) {
            ItemLine swkLine = (ItemLine)swkShape;
            swkLine.arrowShapeA = this.arrowShapeA;
            swkLine.arrowShapeB = this.arrowShapeB;
            swkLine.arrowShapeC = this.arrowShapeC;
            swkLine.newTransform = true;
        }
    }
}

