/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkDefaultStyledDocument;
import com.onemoonscientific.swank.SwkDocumentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJTextPaneWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.TextMouseEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJTextPane
extends JTextPane
implements SwkWidget,
Printable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    boolean debug = false;
    String jhelptarget = "";
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    boolean processNativeKeyBindings = true;
    int spacing1 = 1;
    int spacing2 = 1;
    int spacing3 = 1;
    String tabs = "";
    String wrap = "word";
    int borderWidth = 0;
    boolean exportSelection;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    Color selectBackground;
    int selectBorderWidth;
    boolean setGrid;
    String takeFocus = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    Point currentPt = new Point(0, 0);
    String currentTag = null;
    String previousTag = null;
    TclObject[] currentTags = null;
    TclObject[] previousTags = null;
    Hashtable focusHash = null;
    Hashtable mouseHash = null;
    Hashtable mouseMotionHash = null;
    Hashtable keyHash = null;
    boolean selectionWindowAdded = false;
    Style defaultStyle = null;
    JViewport jview = null;
    JScrollPane jscroll = null;
    JComponent packComponent = null;
    SwkDefaultStyledDocument doc = null;
    SwkDocumentListener docListener = null;
    int swkwidth = 80;
    int swkheight = 24;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-caretcolor", "-caretposition", "-class", "-contenttype", "-cursor", "-disabledtextcolor", "-editable", "-enabled", "-exportselection", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-jhelptarget", "-nativekeys", "-opaque", "-padx", "-pady", "-page", "-relief", "-requestfocusenabled", "-selectbackground", "-selectborderwidth", "-selectedtextcolor", "-selectforeground", "-selectioncolor", "-selectionend", "-selectionstart", "-setgrid", "-spacing1", "-spacing2", "-spacing3", "-state", "-tabs", "-takefocus", "-text", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-wrap", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_AUTOSCROLLS = 0;
    private static final int OPT_BACKGROUND = 1;
    private static final int OPT_BD = 2;
    private static final int OPT_BG = 3;
    private static final int OPT_BORDER = 4;
    private static final int OPT_BORDERWIDTH = 5;
    private static final int OPT_CARETCOLOR = 6;
    private static final int OPT_CARETPOSITION = 7;
    private static final int OPT_CLASS = 8;
    private static final int OPT_CONTENTTYPE = 9;
    private static final int OPT_CURSOR = 10;
    private static final int OPT_DISABLEDTEXTCOLOR = 11;
    private static final int OPT_EDITABLE = 12;
    private static final int OPT_ENABLED = 13;
    private static final int OPT_EXPORTSELECTION = 14;
    private static final int OPT_FG = 15;
    private static final int OPT_FOCUSABLE = 16;
    private static final int OPT_FOCUSCYCLEROOT = 17;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 18;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 19;
    private static final int OPT_FONT = 20;
    private static final int OPT_FOREGROUND = 21;
    private static final int OPT_HEIGHT = 22;
    private static final int OPT_HIGHLIGHTBACKGROUND = 23;
    private static final int OPT_HIGHLIGHTCOLOR = 24;
    private static final int OPT_HIGHLIGHTTHICKNESS = 25;
    private static final int OPT_INSERTBACKGROUND = 26;
    private static final int OPT_INSERTBORDERWIDTH = 27;
    private static final int OPT_INSERTOFFTIME = 28;
    private static final int OPT_INSERTONTIME = 29;
    private static final int OPT_INSERTWIDTH = 30;
    private static final int OPT_JHELPTARGET = 31;
    private static final int OPT_NATIVEKEYS = 32;
    private static final int OPT_OPAQUE = 33;
    private static final int OPT_PADX = 34;
    private static final int OPT_PADY = 35;
    private static final int OPT_PAGE = 36;
    private static final int OPT_RELIEF = 37;
    private static final int OPT_REQUESTFOCUSENABLED = 38;
    private static final int OPT_SELECTBACKGROUND = 39;
    private static final int OPT_SELECTBORDERWIDTH = 40;
    private static final int OPT_SELECTEDTEXTCOLOR = 41;
    private static final int OPT_SELECTFOREGROUND = 42;
    private static final int OPT_SELECTIONCOLOR = 43;
    private static final int OPT_SELECTIONEND = 44;
    private static final int OPT_SELECTIONSTART = 45;
    private static final int OPT_SETGRID = 46;
    private static final int OPT_SPACING1 = 47;
    private static final int OPT_SPACING2 = 48;
    private static final int OPT_SPACING3 = 49;
    private static final int OPT_STATE = 50;
    private static final int OPT_TABS = 51;
    private static final int OPT_TAKEFOCUS = 52;
    private static final int OPT_TEXT = 53;
    private static final int OPT_TOOLTIPTEXT = 54;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 55;
    private static final int OPT_VISIBLE = 56;
    private static final int OPT_WIDTH = 57;
    private static final int OPT_WRAP = 58;
    private static final int OPT_XSCROLLCOMMAND = 59;
    private static final int OPT_YSCROLLCOMMAND = 60;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJTextPane(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJTextPane.initResources();
        }
        if (className.equals("Text")) {
            this.jview = new JViewport();
            this.packComponent = this.jview;
            this.jview.setView(this);
        } else if (className.equals("Stext")) {
            this.jscroll = new JScrollPane(this);
            this.jview = this.jscroll.getViewport();
            this.packComponent = this.jscroll;
        } else {
            this.packComponent = this;
        }
        this.doc = new SwkDefaultStyledDocument();
        this.setStyledDocument(this.doc);
        if (this.defaultStyle == null) {
            this.defaultStyle = this.addStyle("__DEFAULT__", null);
        }
        this.initStyle(this.defaultStyle);
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mEvent) {
                SwkJTextPane.this.currentTags = SwkJTextPane.this.getTagFromEvent(mEvent);
                if (SwkJTextPane.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkJTextPane.this.currentTags.length; ++i) {
                    SwkJTextPane.this.currentTag = SwkJTextPane.this.currentTags[i].toString();
                    SwkJTextPane.this.processMouse(mEvent, 2, 0);
                }
            }

            public void mouseReleased(MouseEvent mEvent) {
                SwkJTextPane.this.currentTags = SwkJTextPane.this.getTagFromEvent(mEvent);
                if (SwkJTextPane.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkJTextPane.this.currentTags.length; ++i) {
                    SwkJTextPane.this.currentTag = SwkJTextPane.this.currentTags[i].toString();
                    SwkJTextPane.this.processMouse(mEvent, 2, 1);
                }
            }

            public void mouseClicked(MouseEvent mEvent) {
                SwkJTextPane.this.currentTags = SwkJTextPane.this.getTagFromEvent(mEvent);
                if (SwkJTextPane.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkJTextPane.this.currentTags.length; ++i) {
                    SwkJTextPane.this.currentTag = SwkJTextPane.this.currentTags[i].toString();
                    SwkJTextPane.this.processMouse(mEvent, 2, 2);
                }
            }

            public void mouseEntered(MouseEvent mEvent) {
            }

            public void mouseExited(MouseEvent mEvent) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mEvent) {
                SwkJTextPane.this.processMouseMotion(mEvent);
            }

            public void mouseMoved(MouseEvent mEvent) {
                SwkJTextPane.this.processMouseMotion(mEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FocusCmd.focusWindow = e.getComponent().getName();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJTextPane.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJTextPane.this.mouseX = mEvent.getX();
                SwkJTextPane.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJTextPane.this.mouseX = mEvent.getX();
                SwkJTextPane.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJTextPaneWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setProcessNativeKeyBindings(boolean processNativeKeyBindings) {
        this.processNativeKeyBindings = processNativeKeyBindings;
    }

    public boolean getProcessNativeKeyBindings() {
        return this.processNativeKeyBindings;
    }

    public void setSpacing1(int spacing1) {
        if (spacing1 < 0) {
            spacing1 = 0;
        }
        this.spacing1 = spacing1;
    }

    public int getSpacing1() {
        return this.spacing1;
    }

    public void setSpacing2(int spacing2) {
        if (spacing2 < 0) {
            spacing2 = 0;
        }
        this.spacing2 = spacing2;
    }

    public int getSpacing2() {
        return this.spacing2;
    }

    public void setSpacing3(int spacing3) {
        if (spacing3 < 0) {
            spacing3 = 0;
        }
        this.spacing3 = spacing3;
    }

    public int getSpacing3() {
        return this.spacing3;
    }

    public void setState(String state) {
        if ("normal".startsWith(state)) {
            this.setEditable(true);
        } else if ("active".startsWith(state)) {
            this.setEditable(true);
        } else if ("disabled".startsWith(state)) {
            this.setEditable(false);
        }
    }

    public String getState() {
        String state = "normal";
        if (!this.isEditable()) {
            state = "disabled";
        }
        return state;
    }

    public void setTabs(String tabs) {
        this.tabs = tabs.intern();
    }

    public String getTabs() {
        return this.tabs;
    }

    public void setWrap(String value) {
        this.wrap = "none".startsWith(value) ? "none" : ("char".startsWith(value) ? "char" : ("word".startsWith(value) ? "word" : "word"));
    }

    public String getWrap() {
        return this.wrap;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setExportSelection(boolean exportSelection) {
        this.exportSelection = exportSelection;
    }

    public String getExportSelection() {
        if (this.exportSelection) {
            return "1";
        }
        return "0";
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setSelectBackground(Color selectBackground) {
        this.selectBackground = selectBackground;
    }

    public Color getSelectBackground() {
        return this.selectBackground;
    }

    public void setSelectBorderWidth(int selectBorderWidth) {
        this.selectBorderWidth = selectBorderWidth;
    }

    public int getSelectBorderWidth() {
        return this.selectBorderWidth;
    }

    public void setSetGrid(boolean setGrid) {
        this.setGrid = setGrid;
    }

    public String getSetGrid() {
        if (this.setGrid) {
            return "1";
        }
        return "0";
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    void processMouseClick(MouseEvent e) {
    }

    void processMouseMotion(MouseEvent mEvent) {
        block12: {
            int j;
            int i;
            boolean wasPresent;
            block11: {
                this.previousTags = this.currentTags;
                boolean stillPresent = false;
                wasPresent = false;
                this.currentTags = this.getTagFromEvent(mEvent);
                if (this.currentTags == null && this.previousTags != null) {
                    for (i = 0; i < this.previousTags.length; ++i) {
                        this.previousTag = this.previousTags[i].toString();
                        this.processMouse(mEvent, 2, 4);
                    }
                } else if (this.currentTags != null && this.previousTags != null) {
                    for (i = 0; i < this.previousTags.length; ++i) {
                        this.previousTag = this.previousTags[i].toString();
                        stillPresent = false;
                        for (j = 0; j < this.currentTags.length; ++j) {
                            this.currentTag = this.currentTags[j].toString();
                            if (!this.previousTags[i].toString().equals(this.currentTag)) continue;
                            stillPresent = true;
                            break;
                        }
                        if (stillPresent) continue;
                        this.processMouse(mEvent, 2, 4);
                    }
                }
                if (this.currentTags != null) {
                    for (i = 0; i < this.currentTags.length; ++i) {
                        this.currentTag = this.currentTags[i].toString();
                        this.processMouse(mEvent, 4, 9);
                    }
                }
                if (this.currentTags == null || this.previousTags != null) break block11;
                for (i = 0; i < this.currentTags.length; ++i) {
                    this.currentTag = this.currentTags[i].toString();
                    this.processMouse(mEvent, 2, 3);
                }
                break block12;
            }
            if (this.currentTags == null || this.previousTags == null) break block12;
            for (i = 0; i < this.currentTags.length; ++i) {
                this.currentTag = this.currentTags[i].toString();
                wasPresent = false;
                for (j = 0; j < this.previousTags.length; ++j) {
                    if (!this.previousTags[j].toString().equals(this.currentTags[i].toString())) continue;
                    wasPresent = true;
                    break;
                }
                if (wasPresent) continue;
                this.processMouse(mEvent, 2, 3);
            }
        }
    }

    public void processMouse(MouseEvent e, int type, int subtype) {
        Vector bindings = null;
        if (type == 1) {
            if (this.currentTag != null && this.focusHash != null) {
                bindings = (Vector)this.focusHash.get(this.currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 2) {
            if (subtype == 4) {
                if (this.previousTag != null && this.mouseHash != null) {
                    bindings = (Vector)this.mouseHash.get(this.previousTag);
                }
            } else if (this.currentTag != null && this.mouseHash != null) {
                bindings = (Vector)this.mouseHash.get(this.currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 4) {
            if (this.currentTag != null && this.mouseMotionHash != null) {
                bindings = (Vector)this.mouseMotionHash.get(this.currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 3) {
            if (this.currentTag != null && this.keyHash != null) {
                bindings = (Vector)this.keyHash.get(this.currentTag);
            }
            if (bindings == null) {
                return;
            }
        }
        TextMouseEvent bEvent = new TextMouseEvent(this.interp, this, e, bindings, type, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void processMouseEvent(MouseEvent e, Vector bindings, int type, int subtype) {
        int mods = e.getModifiersEx();
        int buttons = e.getButton();
        for (int i = 0; i < bindings.size(); ++i) {
            SwkBinding binding = (SwkBinding)bindings.elementAt(i);
            if (binding.subtype != subtype) continue;
            if (subtype != 3 && subtype != 4) {
                if (type != 4 && e.getClickCount() > 0 && binding.count != e.getClickCount() || (type != 4 ? type == 2 && !SwkMouseMotionListener.checkButtons(binding.detail, buttons) : !SwkMouseMotionListener.checkButtonState(e, binding.mod, mods))) continue;
                if (!SwkMouseMotionListener.checkMods(binding.mod, mods)) continue;
            }
            if (binding.command == null || binding.command.length() == 0) continue;
            try {
                BindCmd.doCmd(this.interp, binding.command, e);
                continue;
            }
            catch (TclException tclE) {
                if (tclE.getCompletionCode() == 3) break;
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }

    public TclObject[] getTagFromEvent(MouseEvent mEvent) {
        AttributeSet attrs;
        Element elem;
        String tagName = null;
        this.currentPt.setLocation(mEvent.getX(), mEvent.getY());
        int offset = this.viewToModel(this.currentPt);
        boolean onTag = false;
        try {
            Rectangle view = this.modelToView(offset);
            int dy = mEvent.getY() - view.y;
            int dx = Math.abs(mEvent.getX() - view.x);
            if (dy >= 2 && dy < view.height - 2 && dx >= 0 && dx < view.height * 3 / 4) {
                onTag = true;
            }
        }
        catch (BadLocationException blE) {
            // empty catch block
        }
        if (onTag && (elem = this.doc.getCharacterElement(offset)) != null && (attrs = elem.getAttributes()) != null) {
            tagName = (String)attrs.getAttribute("tagName");
        }
        if (tagName != null) {
            try {
                TclObject[] tags = TclList.getElements((Interp)this.interp, (TclObject)TclString.newInstance(tagName));
                return tags;
            }
            catch (TclException tclE) {
                return null;
            }
        }
        return null;
    }

    public void setupBinding(Interp interp, SwkBinding binding, String tagName) {
        Vector<SwkBinding> bindVec = null;
        if (binding.type == 1) {
            if (this.focusHash == null) {
                this.focusHash = new Hashtable();
                bindVec = new Vector<SwkBinding>(2);
                this.focusHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.focusHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.focusHash.put(tagName, bindVec);
                }
            }
            bindVec.addElement(binding);
        } else if (binding.type == 2) {
            if (this.mouseHash == null) {
                this.mouseHash = new Hashtable();
                bindVec = new Vector(2);
                this.mouseHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.mouseHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.mouseHash.put(tagName, bindVec);
                }
            }
            bindVec.addElement(binding);
        } else if (binding.type == 4) {
            if (this.mouseMotionHash == null) {
                this.mouseMotionHash = new Hashtable();
                bindVec = new Vector(2);
                this.mouseMotionHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.mouseMotionHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.mouseMotionHash.put(tagName, bindVec);
                }
            }
            bindVec.addElement(binding);
        } else if (binding.type == 3) {
            if (this.keyHash == null) {
                this.keyHash = new Hashtable();
                bindVec = new Vector(2);
                this.keyHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.keyHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector(2);
                    this.keyHash.put(tagName, bindVec);
                }
            }
            bindVec.addElement(binding);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent e, int condition, boolean pressed) {
        if (this.processNativeKeyBindings) {
            return super.processKeyBinding(keyStroke, e, condition, pressed);
        }
        return true;
    }

    static void setStyleStuff(Interp interp, Style style, TclObject[] argv, int start) throws TclException {
        for (int i = start; i < argv.length; i += 2) {
            String argType = argv[i].toString();
            if (i + 1 == argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            if (argType.equals("-font")) {
                if (argv[i + 1].toString().length() <= 0) continue;
                SwkJTextPane.setFontStuff(interp, style, argv[i + 1]);
                continue;
            }
            if (argType.equals("-background")) {
                if (argv[i + 1].toString().length() > 0) {
                    Color background = SwankUtil.getColor(interp, argv[i + 1]);
                    StyleConstants.setBackground(style, background);
                    continue;
                }
                StyleConstants.setBackground(style, Color.white);
                continue;
            }
            if (argType.equals("-foreground")) {
                if (argv[i + 1].toString().length() > 0) {
                    Color foreground = SwankUtil.getColor(interp, argv[i + 1]);
                    if (foreground == null) {
                        throw new TclException(interp, "invalid color");
                    }
                    StyleConstants.setForeground(style, foreground);
                    continue;
                }
                StyleConstants.setForeground(style, Color.black);
                continue;
            }
            if (argType.equals("-justify")) {
                if (argv[i + 1].toString().length() > 0) {
                    if ("left".startsWith(argv[i + 1].toString())) {
                        StyleConstants.setAlignment(style, 0);
                        continue;
                    }
                    if ("right".startsWith(argv[i + 1].toString())) {
                        StyleConstants.setAlignment(style, 2);
                        continue;
                    }
                    if ("center".startsWith(argv[i + 1].toString())) {
                        StyleConstants.setAlignment(style, 1);
                        continue;
                    }
                    if ("justify".startsWith(argv[i + 1].toString())) {
                        StyleConstants.setAlignment(style, 3);
                        continue;
                    }
                    throw new TclException(interp, "invalid justification");
                }
                StyleConstants.setAlignment(style, 0);
                continue;
            }
            if (argType.equals("-underline")) {
                if (argv[i + 1].toString().length() > 0) {
                    boolean underline = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    StyleConstants.setUnderline(style, underline);
                    continue;
                }
                StyleConstants.setUnderline(style, false);
                continue;
            }
            if (argType.equals("-overstrike")) {
                if (argv[i + 1].toString().length() > 0) {
                    boolean strikethrough = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    StyleConstants.setStrikeThrough(style, strikethrough);
                    continue;
                }
                StyleConstants.setStrikeThrough(style, false);
                continue;
            }
            if (argType.equals("-strikethrough")) {
                if (argv[i + 1].toString().length() > 0) {
                    boolean strikethrough = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    StyleConstants.setStrikeThrough(style, strikethrough);
                    continue;
                }
                StyleConstants.setStrikeThrough(style, false);
                continue;
            }
            if (argType.equals("-superscript")) {
                if (argv[i + 1].toString().length() > 0) {
                    boolean superscript = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    StyleConstants.setSuperscript(style, superscript);
                    continue;
                }
                StyleConstants.setSuperscript(style, false);
                continue;
            }
            if (argType.equals("-subscript")) {
                if (argv[i + 1].toString().length() > 0) {
                    boolean subscript = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    StyleConstants.setSubscript(style, subscript);
                    continue;
                }
                StyleConstants.setSubscript(style, false);
                continue;
            }
            if (argType.equals("-lmargin1")) {
                if (argv[i + 1].toString().length() > 0) {
                    float leftMargin1 = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                    StyleConstants.setFirstLineIndent(style, leftMargin1);
                    continue;
                }
                StyleConstants.setFirstLineIndent(style, 0.0f);
                continue;
            }
            if (argType.equals("-lmargin2")) {
                if (argv[i + 1].toString().length() > 0) {
                    float leftMargin2 = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                    StyleConstants.setLeftIndent(style, leftMargin2);
                    continue;
                }
                StyleConstants.setLeftIndent(style, 0.0f);
                continue;
            }
            if (argType.equals("-rmargin")) {
                if (argv[i + 1].toString().length() > 0) {
                    float rightMargin = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                    StyleConstants.setRightIndent(style, rightMargin);
                    continue;
                }
                StyleConstants.setRightIndent(style, 0.0f);
                continue;
            }
            if (argType.equals("-spacing1")) {
                if (argv[i + 1].toString().length() > 0) {
                    float spaceAbove = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                    StyleConstants.setSpaceAbove(style, spaceAbove);
                    continue;
                }
                StyleConstants.setSpaceAbove(style, 1.0f);
                continue;
            }
            if (argType.equals("-spacing2")) {
                if (argv[i + 1].toString().length() > 0) {
                    float lineSpacing = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                    StyleConstants.setLineSpacing(style, lineSpacing);
                    continue;
                }
                StyleConstants.setLineSpacing(style, 1.0f);
                continue;
            }
            if (!argType.equals("-spacing3")) continue;
            if (argv[i + 1].toString().length() > 0) {
                float spaceBelow = (float)SwankUtil.getTkSizeD(interp, null, argv[i + 1]);
                StyleConstants.setSpaceBelow(style, spaceBelow);
                continue;
            }
            StyleConstants.setSpaceBelow(style, 1.0f);
        }
    }

    void getStyleStuff(Interp interp, Style style, TclObject argv, boolean configMode) throws TclException {
        String argType = null;
        if (argv != null) {
            argType = argv.toString();
        }
        TclObject list = null;
        TclObject listAll = TclList.newInstance();
        if (argType == null || argType.equals("-font")) {
            if (!configMode) {
                interp.setResult(SwankUtil.parseFont(this.doc.getFont(style)));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-font"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)SwankUtil.parseFont(this.doc.getFont(style))));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-background")) {
            if (!configMode) {
                interp.setResult(SwankUtil.parseColor(StyleConstants.getBackground(style)));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-background"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)SwankUtil.parseColor(StyleConstants.getBackground(style))));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-foreground")) {
            if (!configMode) {
                interp.setResult(SwankUtil.parseColor(StyleConstants.getForeground(style)));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-foreground"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)SwankUtil.parseColor(StyleConstants.getForeground(style))));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-underline")) {
            if (!configMode) {
                interp.setResult(StyleConstants.isUnderline(style));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-underline"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((boolean)StyleConstants.isUnderline(style)));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-overstrike")) {
            if (!configMode) {
                interp.setResult(StyleConstants.isStrikeThrough(style));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-overstrike"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((boolean)StyleConstants.isStrikeThrough(style)));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-strikethrough")) {
            if (!configMode) {
                interp.setResult(StyleConstants.isStrikeThrough(style));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-strikethrough"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((boolean)StyleConstants.isStrikeThrough(style)));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-superscript")) {
            if (!configMode) {
                interp.setResult(StyleConstants.isSuperscript(style));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-superscript"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((boolean)StyleConstants.isSuperscript(style)));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        if (argType == null || argType.equals("-subscript")) {
            if (!configMode) {
                interp.setResult(StyleConstants.isSubscript(style));
                return;
            }
            list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-subscript"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((boolean)StyleConstants.isSubscript(style)));
            if (argType != null) {
                interp.setResult(list);
                return;
            }
            TclList.append((Interp)interp, (TclObject)listAll, (TclObject)list);
        }
        interp.setResult(listAll);
    }

    void initStyle(Style style) {
        StyleConstants.setFontFamily(style, this.getFont().getFamily());
        StyleConstants.setFontSize(style, this.getFont().getSize());
        StyleConstants.setItalic(style, false);
        StyleConstants.setBold(style, false);
        StyleConstants.setBackground(style, this.getBackground());
        StyleConstants.setForeground(style, this.getForeground());
        StyleConstants.setUnderline(style, false);
        StyleConstants.setStrikeThrough(style, false);
        StyleConstants.setStrikeThrough(style, false);
        StyleConstants.setSuperscript(style, false);
        StyleConstants.setSubscript(style, false);
        StyleConstants.setAlignment(style, 0);
        StyleConstants.setFirstLineIndent(style, 0.0f);
        StyleConstants.setLeftIndent(style, 0.0f);
        StyleConstants.setRightIndent(style, 0.0f);
    }

    static void setFontStuff(Interp interp, Style style, TclObject fontArg) throws TclException {
        TclObject[] fontAttr = TclList.getElements((Interp)interp, (TclObject)fontArg);
        String name = fontAttr[0].toString();
        StyleConstants.setFontFamily(style, name);
        StyleConstants.setBold(style, false);
        StyleConstants.setItalic(style, false);
        if (fontAttr.length > 1) {
            int pointSize = TclInteger.get((Interp)interp, (TclObject)fontAttr[1]);
            StyleConstants.setFontSize(style, pointSize);
        }
        for (int i = 2; i < fontAttr.length; ++i) {
            if (fontAttr[i].toString().startsWith("i")) {
                StyleConstants.setItalic(style, true);
                continue;
            }
            if (!fontAttr[i].toString().startsWith("b")) continue;
            StyleConstants.setBold(style, true);
        }
    }

    @Override
    public void setPage(String urlPage) {
        try {
            URL url = SwankUtil.getURL(this.interp, urlPage);
            super.setPage(url);
        }
        catch (IOException ioE) {
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    @Override
    public void setPage(URL url) {
        try {
            super.setPage(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension size = new Dimension();
        size.height = this.swkheight * fontMetrics.getHeight();
        size.width = this.swkwidth * fontMetrics.charWidth('O');
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getMinimumSize();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension size = new Dimension();
        size.height = this.swkheight * fontMetrics.getHeight();
        size.width = this.swkwidth * fontMetrics.charWidth('O');
        Dimension superSize = super.getMinimumSize();
        if (size.height < superSize.height) {
            size.height = superSize.height;
        }
        if (size.width < superSize.width) {
            size.width = superSize.width;
        }
        return size;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
    }

    public int getSwkHeight() {
        return this.swkheight;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 1: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 2: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 3: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 4: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setCaretColor((Color)setter.oValue);
                break;
            }
            case 7: {
                this.setCaretPosition(setter.iValue);
                break;
            }
            case 8: {
                this.setClassName(setter.sValue);
                break;
            }
            case 9: {
                this.setContentType(setter.sValue);
                break;
            }
            case 10: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 11: {
                this.setDisabledTextColor((Color)setter.oValue);
                break;
            }
            case 12: {
                this.setEditable(setter.bValue);
                break;
            }
            case 13: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 14: {
                this.setExportSelection(setter.bValue);
                break;
            }
            case 15: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 16: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 18: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 19: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 20: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 21: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 23: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 24: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 25: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 26: {
                this.setInsertBackground((Color)setter.oValue);
                break;
            }
            case 27: {
                this.setInsertBorderWidth(setter.iValue);
                break;
            }
            case 28: {
                this.setInsertOffTime(setter.iValue);
                break;
            }
            case 29: {
                this.setInsertOnTime(setter.iValue);
                break;
            }
            case 30: {
                this.setInsertWidth(setter.iValue);
                break;
            }
            case 31: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 32: {
                this.setProcessNativeKeyBindings(setter.bValue);
                break;
            }
            case 33: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 34: {
                this.setPadx(setter.iValue);
                break;
            }
            case 35: {
                this.setPady(setter.iValue);
                break;
            }
            case 36: {
                this.setPage((URL)setter.oValue);
                break;
            }
            case 37: {
                this.setRelief(setter.sValue);
                break;
            }
            case 38: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 39: {
                this.setSelectBackground((Color)setter.oValue);
                break;
            }
            case 40: {
                this.setSelectBorderWidth(setter.iValue);
                break;
            }
            case 41: {
                this.setSelectedTextColor((Color)setter.oValue);
                break;
            }
            case 42: {
                this.setSelectionColor((Color)setter.oValue);
                break;
            }
            case 43: {
                this.setSelectionColor((Color)setter.oValue);
                break;
            }
            case 44: {
                this.setSelectionEnd(setter.iValue);
                break;
            }
            case 45: {
                this.setSelectionStart(setter.iValue);
                break;
            }
            case 46: {
                this.setSetGrid(setter.bValue);
                break;
            }
            case 47: {
                this.setSpacing1(setter.iValue);
                break;
            }
            case 48: {
                this.setSpacing2(setter.iValue);
                break;
            }
            case 49: {
                this.setSpacing3(setter.iValue);
                break;
            }
            case 50: {
                this.setState(setter.sValue);
                break;
            }
            case 51: {
                this.setTabs(setter.sValue);
                break;
            }
            case 52: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 53: {
                this.setText(setter.sValue);
                break;
            }
            case 54: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 55: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 56: {
                this.setVisible(setter.bValue);
                break;
            }
            case 57: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 58: {
                this.setWrap(setter.sValue);
                break;
            }
            case 59: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 60: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block63: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 1: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 2: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 3: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 4: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 6: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 7: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 8: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 9: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 10: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 11: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 15: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 18: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 19: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 20: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 21: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 22: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 23: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 24: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 25: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 26: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 27: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 28: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 29: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 30: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 31: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 32: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 33: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 34: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 35: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 36: {
                    URL value = SwankUtil.getURL(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 37: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 38: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 39: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 40: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 41: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 42: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 43: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 44: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 45: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 46: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 47: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 48: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 49: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 50: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 51: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 52: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 53: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 54: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 55: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 56: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 57: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 58: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 59: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 60: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 1: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 2: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 3: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 4: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 5: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 6: {
                return SwankUtil.parseColor(this.getCaretColor());
            }
            case 7: {
                return Integer.toString(this.getCaretPosition());
            }
            case 8: {
                return this.getClassName();
            }
            case 9: {
                return this.getContentType();
            }
            case 10: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 11: {
                return SwankUtil.parseColor(this.getDisabledTextColor());
            }
            case 12: {
                return this.isEditable() ? "1" : "0";
            }
            case 13: {
                return this.isEnabled() ? "1" : "0";
            }
            case 14: {
                return String.valueOf(this.getExportSelection());
            }
            case 15: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 16: {
                return this.isFocusable() ? "1" : "0";
            }
            case 17: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 18: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 19: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 20: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 21: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 22: {
                return Integer.toString(this.getSwkHeight());
            }
            case 23: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 24: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 25: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 26: {
                return SwankUtil.parseColor(this.getInsertBackground());
            }
            case 27: {
                return SwankUtil.parseTkSize(this.getInsertBorderWidth());
            }
            case 28: {
                return Integer.toString(this.getInsertOffTime());
            }
            case 29: {
                return Integer.toString(this.getInsertOnTime());
            }
            case 30: {
                return SwankUtil.parseTkSize(this.getInsertWidth());
            }
            case 31: {
                return this.getJHelpTarget();
            }
            case 32: {
                return String.valueOf(this.getProcessNativeKeyBindings());
            }
            case 33: {
                return this.isOpaque() ? "1" : "0";
            }
            case 34: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 35: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 36: {
                return SwankUtil.parseURL(this.getPage());
            }
            case 37: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 38: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 39: {
                return SwankUtil.parseColor(this.getSelectBackground());
            }
            case 40: {
                return SwankUtil.parseTkSize(this.getSelectBorderWidth());
            }
            case 41: {
                return SwankUtil.parseColor(this.getSelectedTextColor());
            }
            case 42: {
                return SwankUtil.parseColor(this.getSelectionColor());
            }
            case 43: {
                return SwankUtil.parseColor(this.getSelectionColor());
            }
            case 44: {
                return Integer.toString(this.getSelectionEnd());
            }
            case 45: {
                return Integer.toString(this.getSelectionStart());
            }
            case 46: {
                return String.valueOf(this.getSetGrid());
            }
            case 47: {
                return Integer.toString(this.getSpacing1());
            }
            case 48: {
                return Integer.toString(this.getSpacing2());
            }
            case 49: {
                return Integer.toString(this.getSpacing3());
            }
            case 50: {
                return this.getState();
            }
            case 51: {
                return this.getTabs();
            }
            case 52: {
                return this.getTakeFocus();
            }
            case 53: {
                return this.getText();
            }
            case 54: {
                return this.getToolTipText();
            }
            case 55: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 56: {
                return this.isVisible() ? "1" : "0";
            }
            case 57: {
                return Integer.toString(this.getSwkWidth());
            }
            case 58: {
                return this.getWrap();
            }
            case 59: {
                return this.getXScrollCommand();
            }
            case 60: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 0);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 1);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 2);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 3);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 4);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("caretColor", "CaretColor", 6);
        resourceDB.put("-caretcolor", resourceObject);
        resourceObject = new ResourceObject("caretPosition", "CaretPosition", 7);
        resourceDB.put("-caretposition", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 8);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("contentType", "ContentType", 9);
        resourceDB.put("-contenttype", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 10);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("disabledTextColor", "DisabledTextColor", 11);
        resourceDB.put("-disabledtextcolor", resourceObject);
        resourceObject = new ResourceObject("editable", "Editable", 12);
        resourceDB.put("-editable", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 13);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("exportSelection", "ExportSelection", 14);
        resourceDB.put("-exportselection", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 15);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 16);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 17);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 18);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 19);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 20);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 21);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 22);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 23);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 24);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 25);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("insertBackground", "InsertBackground", 26);
        resourceDB.put("-insertbackground", resourceObject);
        resourceObject = new ResourceObject("insertBorderWidth", "InsertBorderWidth", 27);
        resourceDB.put("-insertborderwidth", resourceObject);
        resourceObject = new ResourceObject("insertOffTime", "InsertOffTime", 28);
        resourceDB.put("-insertofftime", resourceObject);
        resourceObject = new ResourceObject("insertOnTime", "InsertOnTime", 29);
        resourceDB.put("-insertontime", resourceObject);
        resourceObject = new ResourceObject("insertWidth", "InsertWidth", 30);
        resourceDB.put("-insertwidth", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 31);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("nativeKeys", "NativeKeys", 32);
        resourceDB.put("-nativekeys", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 33);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 34);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 35);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("page", "Page", 36);
        resourceDB.put("-page", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 37);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 38);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("selectBackground", "SelectBackground", 39);
        resourceDB.put("-selectbackground", resourceObject);
        resourceObject = new ResourceObject("selectBorderWidth", "SelectBorderWidth", 40);
        resourceDB.put("-selectborderwidth", resourceObject);
        resourceObject = new ResourceObject("selectedTextColor", "SelectedTextColor", 41);
        resourceDB.put("-selectedtextcolor", resourceObject);
        resourceObject = new ResourceObject("selectionForeground", "SelectionForeground", 42);
        resourceDB.put("-selectforeground", resourceObject);
        resourceObject = new ResourceObject("selectionColor", "SelectionColor", 43);
        resourceDB.put("-selectioncolor", resourceObject);
        resourceObject = new ResourceObject("selectionEnd", "SelectionEnd", 44);
        resourceDB.put("-selectionend", resourceObject);
        resourceObject = new ResourceObject("selectionStart", "SelectionStart", 45);
        resourceDB.put("-selectionstart", resourceObject);
        resourceObject = new ResourceObject("setGrid", "SetGrid", 46);
        resourceDB.put("-setgrid", resourceObject);
        resourceObject = new ResourceObject("spacing1", "Spacing1", 47);
        resourceDB.put("-spacing1", resourceObject);
        resourceObject = new ResourceObject("spacing2", "Spacing2", 48);
        resourceDB.put("-spacing2", resourceObject);
        resourceObject = new ResourceObject("spacing3", "Spacing3", 49);
        resourceDB.put("-spacing3", resourceObject);
        resourceObject = new ResourceObject("state", "State", 50);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("tabs", "Tabs", 51);
        resourceDB.put("-tabs", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 52);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 53);
        resourceDB.put("-text", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 54);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 55);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 56);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 57);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("wrap", "Wrap", 58);
        resourceDB.put("-wrap", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 59);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 60);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJTextPane swkjtextpane;

        ResourceDefaultsSetter(Interp interp, SwkJTextPane swkjtextpane) {
            this.interp = interp;
            this.swkjtextpane = swkjtextpane;
        }

        public void run() {
            SwkJTextPane.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJTextPane swkjtextpane;
        int opt = 0;
        String result = "";

        JGet(SwkJTextPane swkjtextpane, int opt) {
            this.swkjtextpane = swkjtextpane;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjtextpane.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJTextPane swkjtextpane;
        ArrayList roValues = null;

        JGetAll(SwkJTextPane swkjtextpane) {
            this.swkjtextpane = swkjtextpane;
        }

        public void run() {
            this.roValues = SwkJTextPane.this.getAllConfigurations();
        }
    }
}

