/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[runtime]", module="[runtime]", source="byterun/meta.c")
public final class Meta {
    private Meta() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Obj.t array")
    public static Value caml_get_global_data(Value value) throws Fail.Exception {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("Meta.get_global_data");
        }
        return codeRunner.getContext().getCodeState().getGlobalData();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="(string * Obj.t) list")
    public static Value caml_get_section_table(Value value) throws Fail.Exception {
        if (OCamlJavaThread.getCodeRunner().isNative()) {
            Fail.invalidArgument("Meta.get_section_table");
        }
        Fail.raiseNotFound();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="Meta.closure")
    public static Value caml_reify_bytecode(Value value, Value value2) throws Fail.Exception {
        int n;
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("Meta.reify_bytecode");
            return Value.UNIT;
        }
        byte[] byArray = value.getBytes();
        assert (value2.asLong() % 4L == 0L || value2.asLong() > (long)byArray.length) : "invalid bytecode";
        int n2 = value2.asCastedInt() / 4;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = byArray[4 * n + 3] << 24 & 0xFF000000 | byArray[4 * n + 2] << 16 & 0xFF0000 | byArray[4 * n + 1] << 8 & 0xFF00 | byArray[4 * n] & 0xFF;
        }
        n = codeRunner.getContext().getCodeState().appendCode(nArray);
        return Value.createClosure(1L, (long)n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "string"}, returnType="unit")
    public static Value caml_register_code_fragment(Value value, Value value2, Value value3) throws Fail.Exception {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("Meta.register_code_fragment");
            return Value.UNIT;
        }
        int n = value2.asCastedInt() / 4;
        codeRunner.getContext().getCodeState().addFragment(n, value3.getBytes());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_realloc_global(Value value) throws Fail.Exception {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("Meta.realloc_global");
        }
        codeRunner.getContext().getCodeState().resizeGlobalData(value.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Obj.t")
    public static Value caml_get_current_environment(Value value) {
        return ((ByteCodeRunner)OCamlJavaThread.getCodeRunner()).getEnv();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "Obj.t", "Obj.t"}, returnType="Obj.t")
    public static Value caml_invoke_traced_function(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("Meta.invoke_traced_function");
        }
        ValueStack valueStack = ((ByteCodeRunner)codeRunner).getStack();
        int n = 6;
        Value[] valueArray = valueStack.popSlice(6);
        valueStack.push(value3);
        valueStack.push(Value.ZERO);
        valueStack.push(value2);
        valueStack.push(value);
        valueStack.pushSlice(valueArray);
        return Value.UNIT;
    }
}

