/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.ThreadPoolExecutor;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="RejectedExecutionHandler", source="")
public final class RejectedExecutionHandler {
    private RejectedExecutionHandler() {
    }

    static java.util.concurrent.RejectedExecutionHandler decode(Value value) {
        switch ((int)value.asLong()) {
            case 0: {
                return new ThreadPoolExecutor.AbortPolicy();
            }
            case 1: {
                return new ThreadPoolExecutor.CallerRunsPolicy();
            }
            case 2: {
                return new ThreadPoolExecutor.DiscardOldestPolicy();
            }
            case 3: {
                return new ThreadPoolExecutor.DiscardPolicy();
            }
        }
        assert (false) : "should not happen";
        return null;
    }

    static Value encode(java.util.concurrent.RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler instanceof ThreadPoolExecutor.AbortPolicy) {
            return Value.ZERO;
        }
        if (rejectedExecutionHandler instanceof ThreadPoolExecutor.CallerRunsPolicy) {
            return Value.ONE;
        }
        if (rejectedExecutionHandler instanceof ThreadPoolExecutor.DiscardOldestPolicy) {
            return Value.TWO;
        }
        if (rejectedExecutionHandler instanceof ThreadPoolExecutor.DiscardPolicy) {
            return Value.THREE;
        }
        assert (false) : "should not happen";
        return null;
    }
}

