/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/open.c")
public final class Open {
    private static final Value SIGIO_SIGNAL = Value.createLong(SignalKind.ALRM.getNo());
    private static final String MAIN_WINDOW_ID = "0";

    private Open() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_open_graph(Value value) throws Fail.Exception {
        Context context = CurrentContext.CONTEXT;
        CodeState codeState = context.getCodeState();
        GraphSlot graphSlot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (graphSlot != null) {
            Open.caml_gr_clear_graph(Value.UNIT);
        } else {
            String[] stringArray = value.asString().split(" ");
            String string = stringArray[stringArray.length - 1];
            String string2 = (String)codeState.getSlot(GraphSlot.SLOT_TITLE);
            if (string2 == null) {
                codeState.registerSlot(GraphSlot.SLOT_TITLE, "OCaml graphics");
                string2 = "OCaml graphics";
            }
            try {
                graphSlot = new GraphSlot(context.getParameters(), string2, string);
            }
            catch (HeadlessException headlessException) {
                GraphSlot.fail("Cannot open display", "");
            }
            codeState.registerSlot(GraphSlot.SLOT, graphSlot);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="GraphicsX11.window_id")
    public static Value caml_gr_window_id(Value value) throws Fail.Exception {
        GraphSlot.checkGraph();
        return Value.createString(MAIN_WINDOW_ID);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_close_graph(Value value) {
        CodeState codeState = CurrentContext.CODE_STATE;
        GraphSlot graphSlot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (graphSlot != null) {
            Frame frame = graphSlot.getFrame();
            if (frame != null) {
                frame.setVisible(false);
                frame.dispose();
            }
            codeState.removeSlot(GraphSlot.SLOT);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_set_window_title(Value value) {
        CodeState codeState = CurrentContext.CODE_STATE;
        String string = value.asString();
        codeState.registerSlot(GraphSlot.SLOT_TITLE, string);
        GraphSlot graphSlot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (graphSlot != null) {
            graphSlot.getFrame().setTitle(string);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_resize_window(Value value, Value value2) throws Fail.Exception {
        if (!CurrentContext.PARAMETERS.isBareCanvas()) {
            GraphSlot.checkGraph().changeSize(value.asCastedInt(), value2.asCastedInt());
            Open.caml_gr_clear_graph(Value.UNIT);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_clear_graph(Value value) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        BufferedImage bufferedImage = graphSlot.getBuffer();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.setColor(graphSlot.getBackground());
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.setColor(graphSlot.getBackground());
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_size_x(Value value) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getWidth());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_size_y(Value value) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getHeight());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_gr_display_mode(Value value) throws Fail.Exception {
        GraphSlot.checkGraph().setDisplayMode(value != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_gr_remember_mode(Value value) throws Fail.Exception {
        GraphSlot.checkGraph().setRememberMode(value != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_synchronize(Value value) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        Graphics2D graphics2D = graphSlot.getBuffer().createGraphics();
        graphics2D.drawImage((Image)graphSlot.getBackingStore(), 0, 0, null);
        graphics2D.dispose();
        graphSlot.repaint();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_sigio_signal(Value value) {
        return SIGIO_SIGNAL;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_sigio_handler(Value value) {
        return Value.UNIT;
    }
}

