/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.kernel.Fatal;

public final class IntegerUtils {
    private static final int BYTE_CARDINAL = 256;
    private static final int SHORT_CARDINAL = 65536;
    private static final long INTEGER_CARDINAL = 0x100000000L;

    private IntegerUtils() {
    }

    public static long signedToUnsigned(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int unsignedToSigned(long l) {
        assert (l >= 0L && l < 0x100000000L) : "x should be in 0..INTEGER_CARDINAL-1";
        return (int)l;
    }

    public static int signedToUnsignedByte(int n) {
        assert (n >= -128 && n <= 127) : "x should be in Byte.MIN_VALUE..Byte.MAX_VALUE";
        return n & 0xFF;
    }

    public static int unsignedToSignedByte(int n) {
        assert (n >= 0 && n < 256) : "x should be in 0..BYTE_CARDINAL-1";
        return (byte)n;
    }

    public static int signedToUnsignedShort(int n) {
        assert (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) : "x should be in Short.MIN_VALUE..Short.MAX_VALUE";
        return n & 0xFFFF;
    }

    public static int unsignedToSignedShort(int n) {
        assert (n >= 0 && n < 65536) : "x should be in 0..SHORT_CARDINAL-1";
        return (short)n;
    }

    public static int ensure32s(long l) throws Fatal.Exception {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        Fatal.raise64bitElement();
        return 0;
    }
}

