/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import org.ocamljava.runtime.context.BasicFileHook;
import org.ocamljava.runtime.context.ChannelMap;
import org.ocamljava.runtime.context.FileHook;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.values.Value;

public final class FilesState {
    private File pwd;
    private FileHook fileHook;
    private final ChannelMap channels;

    FilesState(CommonParameters commonParameters, File file) {
        assert (commonParameters != null) : "null p";
        assert (file != null) : "null dir";
        this.pwd = file;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(commonParameters.getEmbeddedBase());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fileHook = commonParameters.isEmbedded() ? new BasicFileHook(clazz) : null;
        this.channels = new ChannelMap();
        Channel channel = new Channel(commonParameters.getStandardInput());
        Channel channel2 = new Channel(commonParameters.getStandardOutput());
        Channel channel3 = new Channel(commonParameters.getStandardError());
        channel.setFD(0);
        channel2.setFD(1);
        channel3.setFD(2);
        this.channels.put(0, channel);
        this.channels.put(1, channel2);
        this.channels.put(2, channel3);
    }

    public synchronized File getPwd() {
        return this.pwd;
    }

    public synchronized void setPwd(File file) {
        assert (file != null) : "null path";
        this.pwd = file;
    }

    public synchronized File getRealFile(String string) {
        assert (string != null) : "null name";
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getPwd(), string);
    }

    public synchronized File getRealFile(Value value) {
        assert (value != null) : "null name";
        return this.getRealFile(value.asString());
    }

    public synchronized String resourceNameFromPath(Value value) {
        assert (value != null) : "null path";
        String string = value.asString().replace('\\', '/');
        if (string.startsWith("/")) {
            return string;
        }
        String string2 = this.getPwd().toString();
        if (string2.endsWith("/")) {
            return string2 + string;
        }
        return string2 + "/" + string;
    }

    public synchronized InputStream getInputStreamForPath(Value value) throws IOException {
        InputStream inputStream;
        assert (value != null) : "null path";
        if (this.fileHook != null && (inputStream = this.fileHook.getInputStream(this.resourceNameFromPath(value))) != null) {
            return inputStream;
        }
        return new FileInputStream(this.getRealFile(value));
    }

    public synchronized URL getURLForPath(Value value) throws IOException {
        URL uRL;
        assert (value != null) : "null path";
        if (this.fileHook != null && (uRL = this.fileHook.getURL(this.resourceNameFromPath(value))) != null) {
            return uRL;
        }
        return this.getRealFile(value).toURI().toURL();
    }

    public synchronized OutputStream getOutputStreamForPath(Value value) throws IOException {
        return new FileOutputStream(this.getRealFile(value));
    }

    public synchronized void setFileHook(FileHook fileHook) {
        this.fileHook = fileHook;
    }

    public synchronized FileHook getFileHook() {
        return this.fileHook;
    }

    public synchronized Channel getChannel(int n) {
        return this.channels.get(n);
    }

    public synchronized int addChannel(Channel channel) {
        assert (channel != null) : "null ch";
        int n = this.channels.firstAvailableKey();
        this.channels.put(n, channel);
        channel.setFD(n);
        return n;
    }

    public synchronized Channel removeChannel(int n) {
        return this.channels.remove(n);
    }

    public synchronized boolean closeChannel(int n) throws IOException {
        Channel channel = this.channels.remove(n);
        if (channel != null) {
            channel.setFD(-1);
            channel.close();
            return true;
        }
        return false;
    }

    public synchronized void setChannel(int n, Channel channel) {
        assert (channel != null) : "null ch";
        this.channels.put(n, channel);
        channel.setFD(n);
    }

    public synchronized Value makeOutChannelsList() {
        Value value = Value.EMPTY_LIST;
        Iterator<Channel> iterator = this.channels.valueIterator();
        while (iterator.hasNext()) {
            Channel channel = iterator.next();
            if (!channel.isOutputChannel()) continue;
            value = Value.createBlock(0, Value.createChannel(channel), value);
        }
        return value;
    }
}

