/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/draw.c")
public final class Draw {
    private Draw() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_plot(Value value, Value value2) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = value.asCastedInt();
        int n2 = graphSlot.convertY(value2.asCastedInt());
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.setStroke(new BasicStroke(1.0f));
            graphics2D2.drawLine(n, n2, n, n2);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.drawLine(n, n2, n, n2);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_moveto(Value value, Value value2) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        graphSlot.setX(value.asCastedInt());
        graphSlot.setY(value2.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_current_x(Value value) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getX());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_current_y(Value value) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getY());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_lineto(Value value, Value value2) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = graphSlot.getX();
        int n2 = graphSlot.convertY(graphSlot.getY());
        int n3 = value.asCastedInt();
        int n4 = value2.asCastedInt();
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.drawLine(n, n2, n3, graphSlot.convertY(n4));
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.drawLine(n, n2, n3, graphSlot.convertY(n4));
            graphics2D.dispose();
        }
        graphSlot.setX(n3);
        graphSlot.setY(n4);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_rect(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = value3.asCastedInt();
        int n2 = value4.asCastedInt();
        int n3 = value.asCastedInt();
        int n4 = graphSlot.convertY(value2.asCastedInt()) - n2;
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.drawRect(n3, n4, n, n2);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.drawRect(n3, n4, n, n2);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_arc(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = value3.asCastedInt();
        int n2 = value4.asCastedInt();
        int n3 = value.asCastedInt() - n;
        int n4 = graphSlot.convertY(value2.asCastedInt()) - n2;
        int n5 = n * 2;
        int n6 = n2 * 2;
        int n7 = value5.asCastedInt();
        int n8 = value6.asCastedInt() - n7;
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.drawArc(n3, n4, n5, n6, n7, n8);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.drawArc(n3, n4, n5, n6, n7, n8);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_arc_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception {
        return Draw.caml_gr_draw_arc(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_set_line_width(Value value) throws Fail.Exception {
        GraphSlot.checkGraph().setLineWidth(value.asCastedInt());
        return Value.UNIT;
    }
}

