/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.primitives.stdlib.Array;
import org.ocamljava.runtime.values.Value;

public final class ArrayFunctions {
    private ArrayFunctions() {
    }

    public static Value init_int(Value value, Value value2) throws Fail.Exception, Fatal.Exception, Throwable {
        long l = value.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        if (l > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        long l2 = 1L;
        int n = 0;
        while ((long)n < l) {
            Value value4 = NativeApply.apply(value2, Value.createFromRawLong(l2));
            value3.setRawLong(n, value4.getRawValue());
            l2 += 2L;
            ++n;
        }
        return value3;
    }

    public static Value of_list_int(Value value) {
        if (value.isBlock()) {
            long l = ArrayFunctions.list_length(value);
            Value value2 = Value.createLongBlockFromSize(0, l);
            long l2 = 0L;
            Value value3 = value;
            while (value3.isBlock()) {
                value2.setRawLong(l2++, value3.get0().getRawValue());
                value3 = value3.get1();
            }
            return value2;
        }
        return CurrentContext.CODE_STATE.getAtom(0);
    }

    public static long list_length(Value value) {
        long l = 0L;
        Value value2 = value;
        while (value2.isBlock()) {
            value2 = value2.get1();
            ++l;
        }
        return l;
    }

    public static Value map_int(Value value, Value value2) throws Fail.Exception, Fatal.Exception, Throwable {
        long l = value2.sizeValues();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        int n = 0;
        while ((long)n < l) {
            Value value4 = NativeApply.apply(value, value2.get(n));
            value3.setRawLong(n, value4.getRawValue());
            ++n;
        }
        return value3;
    }

    public static Value mapi_int(Value value, Value value2) throws Fail.Exception, Fatal.Exception, Throwable {
        long l = value2.sizeValues();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        long l2 = 1L;
        int n = 0;
        while ((long)n < l) {
            Value value4 = NativeApply.apply(value, Value.createFromRawLong(l2), value2.get(n));
            value3.setRawLong(n, value4.getRawValue());
            l2 += 2L;
            ++n;
        }
        return value3;
    }

    public static Value make_matrix_int(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value4 = Value.createBlock(0, l);
        int n = 0;
        while ((long)n < l) {
            value4.set(n, Array.caml_make_vect_int(value2, value3));
            ++n;
        }
        return value4;
    }

    public static Value create_matrix_int(Value value, Value value2, Value value3) throws Fail.Exception {
        return ArrayFunctions.make_matrix_int(value, value2, value3);
    }
}

