/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import java.awt.BasicStroke;

public class StrokeParameters {
    private static final StrokeParameters defaultPar = new StrokeParameters();
    private int cap = 2;
    private int join = 0;
    private float miterLimit = 10.0f;
    private String dashString = "";
    private float[] dash = new float[0];
    private float dashPhase = 0.0f;
    private boolean dashIntPattern = false;

    static StrokeParameters getDefault() {
        return defaultPar;
    }

    BasicStroke getStroke(float width) {
        BasicStroke stroke = null;
        if (this.getDashString().equals("")) {
            stroke = new BasicStroke(width, this.getCap(), this.getJoin(), this.getMiterLimit());
        } else if (this.isDashIntPattern() || width == 1.0f || width == 0.0f) {
            stroke = new BasicStroke(width, this.getCap(), this.getJoin(), this.getMiterLimit(), this.getDash(), this.getDashPhase());
        } else {
            float[] dashTemp = new float[this.getDash().length];
            for (int i = 0; i < this.getDash().length; ++i) {
                dashTemp[i] = this.getDash()[i] * width;
            }
            stroke = new BasicStroke(width, this.getCap(), this.getJoin(), this.getMiterLimit(), dashTemp, this.getDashPhase());
        }
        return stroke;
    }

    public int getCap() {
        return this.cap;
    }

    public static StrokeParameters setCap(StrokeParameters strokePar, int newValue) {
        if (newValue != strokePar.cap) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.cap = newValue;
        }
        return strokePar;
    }

    public int getJoin() {
        return this.join;
    }

    public static StrokeParameters setJoin(StrokeParameters strokePar, int newValue) {
        if (newValue != strokePar.join) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.join = newValue;
        }
        return strokePar;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public static StrokeParameters setMiterLimit(StrokeParameters strokePar, float newValue) {
        if (newValue != strokePar.miterLimit) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.miterLimit = newValue;
        }
        return strokePar;
    }

    public String getDashString() {
        return this.dashString;
    }

    public static StrokeParameters setDashString(StrokeParameters strokePar, String newValue) {
        if (!newValue.equals(strokePar.dashString)) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.dashString = newValue;
        }
        return strokePar;
    }

    public float[] getDash() {
        return this.dash;
    }

    public static StrokeParameters setDash(StrokeParameters strokePar, float[] newValue) {
        boolean change = false;
        if (newValue.length != strokePar.dash.length) {
            change = true;
        } else {
            for (int i = 0; i < newValue.length; ++i) {
                if (newValue[i] == strokePar.dash[i]) continue;
                change = true;
                break;
            }
        }
        if (change) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.dash = newValue;
        }
        return strokePar;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public static StrokeParameters setDashPhase(StrokeParameters strokePar, float newValue) {
        if (newValue != strokePar.dashPhase) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.dashPhase = newValue;
        }
        return strokePar;
    }

    public boolean isDashIntPattern() {
        return this.dashIntPattern;
    }

    public static StrokeParameters setDashIntPattern(StrokeParameters strokePar, boolean newValue) {
        if (newValue != strokePar.dashIntPattern) {
            if (strokePar == defaultPar) {
                strokePar = new StrokeParameters();
            }
            strokePar.dashIntPattern = newValue;
        }
        return strokePar;
    }
}

