/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SwkTreeObject;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;

public class SwkTreeModel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    private SwkTreeObject rootObject;
    protected String procBase = "";
    Interp interp = null;

    public SwkTreeModel(Interp interp, String procBase, String root) {
        this.rootObject = new SwkTreeObject(interp, root);
        this.interp = interp;
        this.procBase = procBase.intern();
    }

    public void showNewRoot(Object newRoot) {
        SwkTreeObject oldRoot = this.rootObject;
        if (newRoot != null) {
            this.rootObject = (SwkTreeObject)newRoot;
        }
        this.fireTreeStructureChanged(oldRoot);
    }

    protected void fireTreeStructureChanged(Object oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    public Object getChild(Object parent, int index) {
        try {
            this.interp.eval(this.procBase + "getChild {" + ((SwkTreeObject)parent).string + "} " + index);
            return new SwkTreeObject(this.interp, this.interp.getResult().toString());
        }
        catch (TclException tclE) {
            System.out.println("getChild " + tclE.toString());
            System.out.println(this.interp.getResult().toString());
            return null;
        }
    }

    public int getChildCount(Object parent) {
        if (parent == null || parent.toString().length() == 0) {
            return 0;
        }
        try {
            this.interp.eval(this.procBase + "getChildCount {" + ((SwkTreeObject)parent).string + "}");
            return TclInteger.get((Interp)this.interp, (TclObject)this.interp.getResult());
        }
        catch (TclException tclE) {
            System.out.println("getChildCount " + tclE.toString());
            System.out.println(this.interp.getResult().toString());
            return 0;
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || parent.toString().length() == 0) {
            return -1;
        }
        if (child == null || child.toString().length() == 0) {
            return -1;
        }
        try {
            this.interp.eval(this.procBase + "getIndexOfChild {" + ((SwkTreeObject)parent).string + "} {" + ((SwkTreeObject)parent).string + "}");
            return TclInteger.get((Interp)this.interp, (TclObject)this.interp.getResult());
        }
        catch (TclException tclE) {
            System.out.println("getIndexOfChild " + tclE.toString());
            System.out.println(this.interp.getResult().toString());
            return -1;
        }
    }

    public Object getRoot() {
        return this.rootObject;
    }

    public boolean isLeaf(Object node) {
        if (node == null || node.toString().length() == 0) {
            return true;
        }
        try {
            this.interp.eval(this.procBase + "getChildCount {" + ((SwkTreeObject)node).string + "}");
            return TclInteger.get((Interp)this.interp, (TclObject)this.interp.getResult()) == 0;
        }
        catch (TclException tclE) {
            System.out.println("getChildCount " + tclE.toString());
            System.out.println(this.interp.getResult().toString());
            return true;
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }
}

