/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SetStringVarEvent;
import com.onemoonscientific.swank.TraceLock;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class SwkDocumentListener
implements DocumentListener,
VarTrace,
TraceLock {
    Interp interp;
    String varName = null;
    JTextComponent jtext;
    boolean traceLock = false;
    boolean insertLock = false;
    boolean removeLock = false;

    SwkDocumentListener(Interp interp, JTextComponent jtext) {
        this.interp = interp;
        this.jtext = jtext;
    }

    public void setInsertLock(boolean newValue) {
        this.insertLock = newValue;
    }

    public void setRemoveLock(boolean newValue) {
        this.removeLock = newValue;
    }

    public void setTraceLock(boolean newValue) {
        this.traceLock = newValue;
    }

    public void traceProc(Interp interp, String string1, String string2, int flags) throws TclException {
        if (this.traceLock) {
            this.traceLock = false;
            return;
        }
        if (EventQueue.isDispatchThread()) {
            // empty if block
        }
        this.setFromVar(interp);
    }

    public void setFromVar(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkDocumentListener: setFromVar on event thread");
        }
        if (this.varName != null) {
            try {
                TclObject tobj = interp.getVar(this.varName, 1);
                final String s1 = tobj.toString();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (s1.length() == 0) {
                            if (SwkDocumentListener.this.jtext.getText().length() != 0) {
                                SwkDocumentListener.this.setRemoveLock(true);
                            }
                        } else {
                            SwkDocumentListener.this.setRemoveLock(true);
                            SwkDocumentListener.this.setInsertLock(true);
                        }
                        SwkDocumentListener.this.jtext.setText(s1);
                    }
                });
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
    }

    public void setVarName(String name) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("SwkDocumentListener: setVarName on event thread");
        }
        if (this.varName != null && !this.varName.equals("")) {
            this.interp.untraceVar(this.varName, (VarTrace)this, 33);
        }
        if (name != null && name != "") {
            try {
                TclObject tobj = this.interp.getVar(name, 1);
                final String s1 = tobj.toString();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (s1.length() == 0) {
                            if (SwkDocumentListener.this.jtext.getText().length() != 0) {
                                SwkDocumentListener.this.setRemoveLock(true);
                            }
                        } else {
                            SwkDocumentListener.this.setRemoveLock(true);
                            SwkDocumentListener.this.setInsertLock(true);
                        }
                        SwkDocumentListener.this.jtext.setText(s1);
                    }
                });
            }
            catch (TclException tclException) {
                this.interp.resetResult();
                TclObject tobj = TclString.newInstance((String)"");
                this.interp.setVar(name, tobj, 1);
            }
            this.interp.traceVar(name, (VarTrace)this, 33);
        }
        this.varName = name;
    }

    public String getVarName() {
        return this.varName;
    }

    public void updateVar(DocumentEvent docEvent) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        if (this.varName == null) {
            return;
        }
        Document doc = docEvent.getDocument();
        String string = null;
        try {
            string = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        SetStringVarEvent dvEvent = new SetStringVarEvent(this.interp, this, this.varName, null, string);
        this.interp.getNotifier().queueEvent((TclEvent)dvEvent, 0);
    }

    public void insertUpdate(DocumentEvent docEvent) {
        if (!this.insertLock) {
            this.updateVar(docEvent);
        } else {
            this.setInsertLock(false);
            this.setRemoveLock(false);
        }
    }

    public void removeUpdate(DocumentEvent docEvent) {
        if (!this.removeLock) {
            this.updateVar(docEvent);
        } else {
            this.setRemoveLock(false);
        }
    }

    public void changedUpdate(DocumentEvent docEvent) {
        this.updateVar(docEvent);
    }
}

