/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas.SwkCanvas;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class ClipboardCmd
implements Command,
ClipboardOwner {
    private static final String[] validCmds = new String[]{"append", "clear", "get", "pastewidget"};
    private static final int OPT_APPEND = 0;
    private static final int OPT_CLEAR = 1;
    private static final int OPT_GET = 2;
    private static final int OPT_PASTEWIDGET = 3;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        switch (opt) {
            case 0: {
                String current = this.getClipboardAsText(interp, clipboard);
                StringSelection stringSelection = new StringSelection(current + argv[argv.length - 1].toString());
                clipboard.setContents(stringSelection, this);
                break;
            }
            case 1: {
                interp.resetResult();
                StringSelection stringSelection = new StringSelection("");
                clipboard.setContents(stringSelection, this);
                break;
            }
            case 2: {
                interp.setResult(this.getClipboardAsText(interp, clipboard));
                break;
            }
            case 3: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "widgetName");
                }
                Component comp = null;
                comp = (Component)Widgets.get(interp, argv[2].toString());
                if (comp == null) {
                    throw new TclException(interp, "can't get component for font command");
                }
                if (!(comp instanceof SwkCanvas)) {
                    throw new TclException(interp, "this widget can't be copied to clipboard yet");
                }
                SwkCanvas swkcanvas = (SwkCanvas)comp;
                TransferHandler handler = swkcanvas.getTransferHandler();
                System.out.println("exporting to clipboard");
                handler.exportToClipboard((JComponent)comp, clipboard, 1);
                interp.setResult("");
                break;
            }
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    String getClipboardAsText(Interp interp, Clipboard clipboard) throws TclException {
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return "";
        }
        DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
        try {
            return transferable.getTransferData(DataFlavor.selectBestTextFlavor(dataFlavors)).toString();
        }
        catch (Exception exc) {
            throw new TclException(interp, exc.toString());
        }
    }
}

