/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.labltk.CamlTimer;
import org.ocamljava.runtime.primitives.otherlibs.labltk.CamlVarTrace;
import org.ocamljava.runtime.primitives.otherlibs.labltk.InputWaiterThread;
import org.ocamljava.runtime.values.Value;
import tcl.lang.Interp;
import tcl.lang.TimerHandler;
import tcl.lang.VarTrace;

public final class TKSlot {
    public static final Object SLOT = new Object();
    private final Value tkError;
    private final Value handlerCode;
    private Interp interpreter;
    private final Map<Long, VarTrace> varTraces;
    private final Map<Long, TimerHandler> timerHandlers;
    private final Map<Long, InputWaiterThread> inputWaiterThreads;

    public TKSlot(Context ctxt) {
        assert (ctxt != null) : "null ctxt";
        CodeState codeState = ctxt.getCodeState();
        this.tkError = codeState.getCallback("tkerror");
        this.handlerCode = codeState.getCallback("camlcb");
        this.interpreter = null;
        this.varTraces = new HashMap<Long, VarTrace>();
        this.timerHandlers = new HashMap<Long, TimerHandler>();
        this.inputWaiterThreads = new HashMap<Long, InputWaiterThread>();
    }

    public void tkError(String msg) throws Fail.Exception {
        assert (msg != null) : "null msg";
        Fail.raiseWithString((Value)this.tkError, (String)msg);
    }

    public void tkError(Throwable t) throws Fail.Exception {
        assert (t != null) : "null t";
        Fail.raiseWithString((Value)this.tkError, (String)t.getMessage());
    }

    public Interp getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(Interp i) {
        assert (i != null) : "null i";
        this.interpreter = i;
    }

    public Value getHandlerCode() {
        return this.handlerCode;
    }

    public VarTrace getVarTrace(long id) {
        return this.varTraces.get(id);
    }

    public VarTrace createVarTrace(long id) {
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        CamlVarTrace res = new CamlVarTrace(cr, this, id);
        this.varTraces.put(id, res);
        return res;
    }

    public TimerHandler getTimerHandler(long id) {
        return this.timerHandlers.get(id);
    }

    public int createTimerHandler(int milli, long cb) {
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        int res = this.timerHandlers.size();
        CamlTimer th = new CamlTimer(cr, this, cb, milli);
        this.timerHandlers.put(Long.valueOf(res), th);
        return res;
    }

    public void createInputWaiterThread(int fd, long cb) {
        InputStream st;
        long id = (long)fd << 32 | cb;
        Channel ch = CurrentContext.getFilesState().getChannel(fd);
        InputStream inputStream = st = ch != null ? ch.newInputStream() : null;
        if (st != null) {
            InputWaiterThread iwt = new InputWaiterThread(OCamlJavaThread.getCodeRunner(), this, cb, st);
            this.inputWaiterThreads.put(id, iwt);
            iwt.start();
        }
    }

    public void removeInputWaiterThread(int fd, long cb) {
        long id = (long)fd << 32 | cb;
        InputWaiterThread iwt = this.inputWaiterThreads.get(id);
        if (iwt != null) {
            iwt.interrupt();
        }
    }

    static TKSlot checkInit() throws Fail.Exception {
        TKSlot slot = (TKSlot)CurrentContext.getCodeState().getSlot(SLOT);
        if (slot != null) {
            if (slot.getInterpreter() == null) {
                slot.tkError("Tcl/Tk not initialised");
            }
        } else {
            Fail.invalidArgument((String)"Tcl/Tk not initialised");
        }
        return slot;
    }
}

