/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Lock", source="")
public final class Lock {
    private Lock() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"bool"}, returnType="Lock.t")
    public static Value ocamljava_lock_make_reentrant(Value value) {
        return Value.createInstance(new ReentrantLock(value != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_lock(Value value) {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        lock.lock();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_lock_interruptibly(Value value) throws Fail.Exception {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        try {
            lock.lockInterruptibly();
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Lock.try_lock_interruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="Condition.t")
    public static Value ocamljava_lock_new_condition(Value value) {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        Condition condition = lock.newCondition();
        return Value.createInstance(condition);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="bool")
    public static Value ocamljava_lock_try_lock(Value value) {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        boolean bl = lock.tryLock();
        return bl ? Value.TRUE : Value.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t", "int64", "TimeUnit.t"}, returnType="bool")
    public static Value ocamljava_lock_try_lock_time(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        try {
            Value value4;
            boolean bl = lock.tryLock(value2.asInt64(), TimeUnit.decode(value3));
            if (bl) {
                value4 = Value.TRUE;
                return value4;
            }
            value4 = Value.FALSE;
            return value4;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Lock.try_lock_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Lock.t"}, returnType="unit")
    public static Value ocamljava_lock_unlock(Value value) throws Fail.Exception {
        java.util.concurrent.locks.Lock lock = (java.util.concurrent.locks.Lock)value.asCustom();
        try {
            lock.unlock();
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Lock.unlock");
        }
        return Value.UNIT;
    }
}

